// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class FilterLogEventsRequest private constructor(builder: Builder) {
    /**
     * The end of the time range, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp later than this time are not returned.
     */
    public val endTime: kotlin.Long? = builder.endTime
    /**
     * The filter pattern to use. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
     *
     * If not provided, all the events are matched.
     */
    public val filterPattern: kotlin.String? = builder.filterPattern
    /**
     * If the value is true, the operation attempts to provide responses that contain events from multiple log streams within the log group, interleaved in a single response. If the value is false, all the matched log events in the first log stream are searched first, then those in the next log stream, and so on.
     *
     * **Important** As of June 17, 2019, this parameter is ignored and the value is assumed to be true. The response from this operation always interleaves events from multiple log streams within a log group.
     */
    @Deprecated("Starting on June 17, 2019, this parameter will be ignored and the value will be assumed to be true. The response from this operation will always interleave events from multiple log streams within a log group.")
    public val interleaved: kotlin.Boolean? = builder.interleaved
    /**
     * The maximum number of events to return. The default is 10,000 events.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * Specify either the name or ARN of the log group to view log events from. If the log group is in a source account and you are using a monitoring account, you must use the log group ARN.
     *
     *  You must include either `logGroupIdentifier` or `logGroupName`, but not both.
     */
    public val logGroupIdentifier: kotlin.String? = builder.logGroupIdentifier
    /**
     * The name of the log group to search.
     *
     *  You must include either `logGroupIdentifier` or `logGroupName`, but not both.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * Filters the results to include only events from log streams that have names starting with this prefix.
     *
     * If you specify a value for both `logStreamNamePrefix` and `logStreamNames`, but the value for `logStreamNamePrefix` does not match any log stream names specified in `logStreamNames`, the action returns an `InvalidParameterException` error.
     */
    public val logStreamNamePrefix: kotlin.String? = builder.logStreamNamePrefix
    /**
     * Filters the results to only logs from the log streams in this list.
     *
     * If you specify a value for both `logStreamNamePrefix` and `logStreamNames`, the action returns an `InvalidParameterException` error.
     */
    public val logStreamNames: List<String>? = builder.logStreamNames
    /**
     * The token for the next set of events to return. (You received this token from a previous call.)
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The start of the time range, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp before this time are not returned.
     */
    public val startTime: kotlin.Long? = builder.startTime
    /**
     * Specify `true` to display the log event fields with all sensitive data unmasked and visible. The default is `false`.
     *
     * To use this operation with this parameter, you must be signed into an account with the `logs:Unmask` permission.
     */
    public val unmask: kotlin.Boolean? = builder.unmask

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.FilterLogEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FilterLogEventsRequest(")
        append("endTime=$endTime,")
        append("filterPattern=$filterPattern,")
        append("interleaved=$interleaved,")
        append("limit=$limit,")
        append("logGroupIdentifier=$logGroupIdentifier,")
        append("logGroupName=$logGroupName,")
        append("logStreamNamePrefix=$logStreamNamePrefix,")
        append("logStreamNames=$logStreamNames,")
        append("nextToken=$nextToken,")
        append("startTime=$startTime,")
        append("unmask=$unmask")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (filterPattern?.hashCode() ?: 0)
        result = 31 * result + (interleaved?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (logGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (logStreamNamePrefix?.hashCode() ?: 0)
        result = 31 * result + (logStreamNames?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (unmask?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FilterLogEventsRequest

        if (endTime != other.endTime) return false
        if (filterPattern != other.filterPattern) return false
        if (interleaved != other.interleaved) return false
        if (limit != other.limit) return false
        if (logGroupIdentifier != other.logGroupIdentifier) return false
        if (logGroupName != other.logGroupName) return false
        if (logStreamNamePrefix != other.logStreamNamePrefix) return false
        if (logStreamNames != other.logStreamNames) return false
        if (nextToken != other.nextToken) return false
        if (startTime != other.startTime) return false
        if (unmask != other.unmask) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.FilterLogEventsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The end of the time range, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp later than this time are not returned.
         */
        public var endTime: kotlin.Long? = null
        /**
         * The filter pattern to use. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
         *
         * If not provided, all the events are matched.
         */
        public var filterPattern: kotlin.String? = null
        /**
         * If the value is true, the operation attempts to provide responses that contain events from multiple log streams within the log group, interleaved in a single response. If the value is false, all the matched log events in the first log stream are searched first, then those in the next log stream, and so on.
         *
         * **Important** As of June 17, 2019, this parameter is ignored and the value is assumed to be true. The response from this operation always interleaves events from multiple log streams within a log group.
         */
        @Deprecated("Starting on June 17, 2019, this parameter will be ignored and the value will be assumed to be true. The response from this operation will always interleave events from multiple log streams within a log group.")
        public var interleaved: kotlin.Boolean? = null
        /**
         * The maximum number of events to return. The default is 10,000 events.
         */
        public var limit: kotlin.Int? = null
        /**
         * Specify either the name or ARN of the log group to view log events from. If the log group is in a source account and you are using a monitoring account, you must use the log group ARN.
         *
         *  You must include either `logGroupIdentifier` or `logGroupName`, but not both.
         */
        public var logGroupIdentifier: kotlin.String? = null
        /**
         * The name of the log group to search.
         *
         *  You must include either `logGroupIdentifier` or `logGroupName`, but not both.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * Filters the results to include only events from log streams that have names starting with this prefix.
         *
         * If you specify a value for both `logStreamNamePrefix` and `logStreamNames`, but the value for `logStreamNamePrefix` does not match any log stream names specified in `logStreamNames`, the action returns an `InvalidParameterException` error.
         */
        public var logStreamNamePrefix: kotlin.String? = null
        /**
         * Filters the results to only logs from the log streams in this list.
         *
         * If you specify a value for both `logStreamNamePrefix` and `logStreamNames`, the action returns an `InvalidParameterException` error.
         */
        public var logStreamNames: List<String>? = null
        /**
         * The token for the next set of events to return. (You received this token from a previous call.)
         */
        public var nextToken: kotlin.String? = null
        /**
         * The start of the time range, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp before this time are not returned.
         */
        public var startTime: kotlin.Long? = null
        /**
         * Specify `true` to display the log event fields with all sensitive data unmasked and visible. The default is `false`.
         *
         * To use this operation with this parameter, you must be signed into an account with the `logs:Unmask` permission.
         */
        public var unmask: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.FilterLogEventsRequest) : this() {
            this.endTime = x.endTime
            this.filterPattern = x.filterPattern
            this.interleaved = x.interleaved
            this.limit = x.limit
            this.logGroupIdentifier = x.logGroupIdentifier
            this.logGroupName = x.logGroupName
            this.logStreamNamePrefix = x.logStreamNamePrefix
            this.logStreamNames = x.logStreamNames
            this.nextToken = x.nextToken
            this.startTime = x.startTime
            this.unmask = x.unmask
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.FilterLogEventsRequest = FilterLogEventsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
