// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeLogGroupsRequest private constructor(builder: Builder) {
    /**
     * When `includeLinkedAccounts` is set to `True`, use this parameter to specify the list of accounts to search. You can specify as many as 20 account IDs in the array.
     */
    public val accountIdentifiers: List<String>? = builder.accountIdentifiers
    /**
     * If you are using a monitoring account, set this to `True` to have the operation return log groups in the accounts listed in `accountIdentifiers`.
     *
     * If this parameter is set to `true` and `accountIdentifiers` contains a null value, the operation returns all log groups in the monitoring account and all log groups in all source accounts that are linked to the monitoring account.
     */
    public val includeLinkedAccounts: kotlin.Boolean? = builder.includeLinkedAccounts
    /**
     * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * Specifies the log group class for this log group. There are two classes:
     * + The `Standard` log class supports all CloudWatch Logs features.
     * + The `Infrequent Access` log class supports a subset of CloudWatch Logs features and incurs lower costs.
     *
     * For details about the features supported by each class, see [Log classes](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html)
     */
    public val logGroupClass: aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroupClass? = builder.logGroupClass
    /**
     * If you specify a string for this parameter, the operation returns only log groups that have names that match the string based on a case-sensitive substring search. For example, if you specify `Foo`, log groups named `FooBar`, `aws/Foo`, and `GroupFoo` would match, but `foo`, `F/o/o` and `Froo` would not match.
     *
     * If you specify `logGroupNamePattern` in your request, then only `arn`, `creationTime`, and `logGroupName` are included in the response.
     *
     * `logGroupNamePattern` and `logGroupNamePrefix` are mutually exclusive. Only one of these parameters can be passed.
     */
    public val logGroupNamePattern: kotlin.String? = builder.logGroupNamePattern
    /**
     * The prefix to match.
     *
     * `logGroupNamePrefix` and `logGroupNamePattern` are mutually exclusive. Only one of these parameters can be passed.
     */
    public val logGroupNamePrefix: kotlin.String? = builder.logGroupNamePrefix
    /**
     * The token for the next set of items to return. (You received this token from a previous call.)
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogGroupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLogGroupsRequest(")
        append("accountIdentifiers=$accountIdentifiers,")
        append("includeLinkedAccounts=$includeLinkedAccounts,")
        append("limit=$limit,")
        append("logGroupClass=$logGroupClass,")
        append("logGroupNamePattern=$logGroupNamePattern,")
        append("logGroupNamePrefix=$logGroupNamePrefix,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIdentifiers?.hashCode() ?: 0
        result = 31 * result + (includeLinkedAccounts?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (logGroupClass?.hashCode() ?: 0)
        result = 31 * result + (logGroupNamePattern?.hashCode() ?: 0)
        result = 31 * result + (logGroupNamePrefix?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeLogGroupsRequest

        if (accountIdentifiers != other.accountIdentifiers) return false
        if (includeLinkedAccounts != other.includeLinkedAccounts) return false
        if (limit != other.limit) return false
        if (logGroupClass != other.logGroupClass) return false
        if (logGroupNamePattern != other.logGroupNamePattern) return false
        if (logGroupNamePrefix != other.logGroupNamePrefix) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogGroupsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When `includeLinkedAccounts` is set to `True`, use this parameter to specify the list of accounts to search. You can specify as many as 20 account IDs in the array.
         */
        public var accountIdentifiers: List<String>? = null
        /**
         * If you are using a monitoring account, set this to `True` to have the operation return log groups in the accounts listed in `accountIdentifiers`.
         *
         * If this parameter is set to `true` and `accountIdentifiers` contains a null value, the operation returns all log groups in the monitoring account and all log groups in all source accounts that are linked to the monitoring account.
         */
        public var includeLinkedAccounts: kotlin.Boolean? = null
        /**
         * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         */
        public var limit: kotlin.Int? = null
        /**
         * Specifies the log group class for this log group. There are two classes:
         * + The `Standard` log class supports all CloudWatch Logs features.
         * + The `Infrequent Access` log class supports a subset of CloudWatch Logs features and incurs lower costs.
         *
         * For details about the features supported by each class, see [Log classes](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html)
         */
        public var logGroupClass: aws.sdk.kotlin.services.cloudwatchlogs.model.LogGroupClass? = null
        /**
         * If you specify a string for this parameter, the operation returns only log groups that have names that match the string based on a case-sensitive substring search. For example, if you specify `Foo`, log groups named `FooBar`, `aws/Foo`, and `GroupFoo` would match, but `foo`, `F/o/o` and `Froo` would not match.
         *
         * If you specify `logGroupNamePattern` in your request, then only `arn`, `creationTime`, and `logGroupName` are included in the response.
         *
         * `logGroupNamePattern` and `logGroupNamePrefix` are mutually exclusive. Only one of these parameters can be passed.
         */
        public var logGroupNamePattern: kotlin.String? = null
        /**
         * The prefix to match.
         *
         * `logGroupNamePrefix` and `logGroupNamePattern` are mutually exclusive. Only one of these parameters can be passed.
         */
        public var logGroupNamePrefix: kotlin.String? = null
        /**
         * The token for the next set of items to return. (You received this token from a previous call.)
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogGroupsRequest) : this() {
            this.accountIdentifiers = x.accountIdentifiers
            this.includeLinkedAccounts = x.includeLinkedAccounts
            this.limit = x.limit
            this.logGroupClass = x.logGroupClass
            this.logGroupNamePattern = x.logGroupNamePattern
            this.logGroupNamePrefix = x.logGroupNamePrefix
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.DescribeLogGroupsRequest = DescribeLogGroupsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
