// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains information about one *delivery source* in your account. A delivery source is an Amazon Web Services resource that sends logs to an Amazon Web Services destination. The destination can be CloudWatch Logs, Amazon S3, or Firehose.
 *
 * Only some Amazon Web Services services support being configured as a delivery source. These services are listed as **Supported &#91;V2 Permissions&#93;** in the table at [Enabling logging from Amazon Web Services services.](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html)
 *
 * To configure logs delivery between a supported Amazon Web Services service and a destination, you must do the following:
 * + Create a delivery source, which is a logical object that represents the resource that is actually sending the logs. For more information, see [PutDeliverySource](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html).
 * + Create a *delivery destination*, which is a logical object that represents the actual delivery destination. For more information, see [PutDeliveryDestination](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html).
 * + If you are delivering logs cross-account, you must use [PutDeliveryDestinationPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html) in the destination account to assign an IAM policy to the destination. This policy allows delivery to that destination.
 * + Create a *delivery* by pairing exactly one delivery source and one delivery destination. For more information, see [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html).
 *
 * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries. You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery destination.
 */
public class DeliverySource private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies this delivery source.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The type of log that the source is sending. For valid values for this parameter, see the documentation for the source service.
     */
    public val logType: kotlin.String? = builder.logType
    /**
     * The unique name of the delivery source.
     */
    public val name: kotlin.String? = builder.name
    /**
     * This array contains the ARN of the Amazon Web Services resource that sends logs and is represented by this delivery source. Currently, only one ARN can be in the array.
     */
    public val resourceArns: List<String>? = builder.resourceArns
    /**
     * The Amazon Web Services service that is sending logs.
     */
    public val service: kotlin.String? = builder.service
    /**
     * The tags that have been assigned to this delivery source.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.DeliverySource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeliverySource(")
        append("arn=$arn,")
        append("logType=$logType,")
        append("name=$name,")
        append("resourceArns=$resourceArns,")
        append("service=$service,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (logType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceArns?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeliverySource

        if (arn != other.arn) return false
        if (logType != other.logType) return false
        if (name != other.name) return false
        if (resourceArns != other.resourceArns) return false
        if (service != other.service) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.DeliverySource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies this delivery source.
         */
        public var arn: kotlin.String? = null
        /**
         * The type of log that the source is sending. For valid values for this parameter, see the documentation for the source service.
         */
        public var logType: kotlin.String? = null
        /**
         * The unique name of the delivery source.
         */
        public var name: kotlin.String? = null
        /**
         * This array contains the ARN of the Amazon Web Services resource that sends logs and is represented by this delivery source. Currently, only one ARN can be in the array.
         */
        public var resourceArns: List<String>? = null
        /**
         * The Amazon Web Services service that is sending logs.
         */
        public var service: kotlin.String? = null
        /**
         * The tags that have been assigned to this delivery source.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.DeliverySource) : this() {
            this.arn = x.arn
            this.logType = x.logType
            this.name = x.name
            this.resourceArns = x.resourceArns
            this.service = x.service
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.DeliverySource = DeliverySource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
