// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateLogAnomalyDetectorRequest private constructor(builder: Builder) {
    /**
     * The number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in `anomalyVisibilityTime`, it will be considered normal going forward and will not be detected as an anomaly.
     */
    public val anomalyVisibilityTime: kotlin.Long? = builder.anomalyVisibilityTime
    /**
     * A name for this anomaly detector.
     */
    public val detectorName: kotlin.String? = builder.detectorName
    /**
     * Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for `evaluationFrequency` .
     */
    public val evaluationFrequency: aws.sdk.kotlin.services.cloudwatchlogs.model.EvaluationFrequency? = builder.evaluationFrequency
    /**
     * You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
     */
    public val filterPattern: kotlin.String? = builder.filterPattern
    /**
     * Optionally assigns a KMS key to secure this anomaly detector and its findings. If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
     *
     * For more information about using a KMS key and to see the required IAM policy, see [Use a KMS key with an anomaly detector](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/LogsAnomalyDetection-KMS.html).
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * An array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log group ARN.
     */
    public val logGroupArnList: List<String>? = builder.logGroupArnList
    /**
     * An optional list of key-value pairs to associate with the resource.
     *
     * For more information about tagging, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.CreateLogAnomalyDetectorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLogAnomalyDetectorRequest(")
        append("anomalyVisibilityTime=$anomalyVisibilityTime,")
        append("detectorName=$detectorName,")
        append("evaluationFrequency=$evaluationFrequency,")
        append("filterPattern=$filterPattern,")
        append("kmsKeyId=$kmsKeyId,")
        append("logGroupArnList=$logGroupArnList,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalyVisibilityTime?.hashCode() ?: 0
        result = 31 * result + (detectorName?.hashCode() ?: 0)
        result = 31 * result + (evaluationFrequency?.hashCode() ?: 0)
        result = 31 * result + (filterPattern?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logGroupArnList?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLogAnomalyDetectorRequest

        if (anomalyVisibilityTime != other.anomalyVisibilityTime) return false
        if (detectorName != other.detectorName) return false
        if (evaluationFrequency != other.evaluationFrequency) return false
        if (filterPattern != other.filterPattern) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logGroupArnList != other.logGroupArnList) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.CreateLogAnomalyDetectorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in `anomalyVisibilityTime`, it will be considered normal going forward and will not be detected as an anomaly.
         */
        public var anomalyVisibilityTime: kotlin.Long? = null
        /**
         * A name for this anomaly detector.
         */
        public var detectorName: kotlin.String? = null
        /**
         * Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for `evaluationFrequency` .
         */
        public var evaluationFrequency: aws.sdk.kotlin.services.cloudwatchlogs.model.EvaluationFrequency? = null
        /**
         * You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
         */
        public var filterPattern: kotlin.String? = null
        /**
         * Optionally assigns a KMS key to secure this anomaly detector and its findings. If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
         *
         * For more information about using a KMS key and to see the required IAM policy, see [Use a KMS key with an anomaly detector](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/LogsAnomalyDetection-KMS.html).
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * An array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log group ARN.
         */
        public var logGroupArnList: List<String>? = null
        /**
         * An optional list of key-value pairs to associate with the resource.
         *
         * For more information about tagging, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.CreateLogAnomalyDetectorRequest) : this() {
            this.anomalyVisibilityTime = x.anomalyVisibilityTime
            this.detectorName = x.detectorName
            this.evaluationFrequency = x.evaluationFrequency
            this.filterPattern = x.filterPattern
            this.kmsKeyId = x.kmsKeyId
            this.logGroupArnList = x.logGroupArnList
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.CreateLogAnomalyDetectorRequest = CreateLogAnomalyDetectorRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
