// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateExportTaskRequest private constructor(builder: Builder) {
    /**
     * The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services Region.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The prefix used as the start of the key for every object exported. If you don't specify a value, the default is `exportedlogs`.
     */
    public val destinationPrefix: kotlin.String? = builder.destinationPrefix
    /**
     * The start time of the range for the request, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp earlier than this time are not exported.
     */
    public val from: kotlin.Long? = builder.from
    /**
     * The name of the log group.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is applied.
     */
    public val logStreamNamePrefix: kotlin.String? = builder.logStreamNamePrefix
    /**
     * The name of the export task.
     */
    public val taskName: kotlin.String? = builder.taskName
    /**
     * The end time of the range for the request, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp later than this time are not exported.
     *
     * You must specify a time that is not earlier than when this log group was created.
     */
    public val to: kotlin.Long? = builder.to

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.CreateExportTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateExportTaskRequest(")
        append("destination=$destination,")
        append("destinationPrefix=$destinationPrefix,")
        append("from=$from,")
        append("logGroupName=$logGroupName,")
        append("logStreamNamePrefix=$logStreamNamePrefix,")
        append("taskName=$taskName,")
        append("to=$to")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (destinationPrefix?.hashCode() ?: 0)
        result = 31 * result + (from?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (logStreamNamePrefix?.hashCode() ?: 0)
        result = 31 * result + (taskName?.hashCode() ?: 0)
        result = 31 * result + (to?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateExportTaskRequest

        if (destination != other.destination) return false
        if (destinationPrefix != other.destinationPrefix) return false
        if (from != other.from) return false
        if (logGroupName != other.logGroupName) return false
        if (logStreamNamePrefix != other.logStreamNamePrefix) return false
        if (taskName != other.taskName) return false
        if (to != other.to) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.CreateExportTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services Region.
         */
        public var destination: kotlin.String? = null
        /**
         * The prefix used as the start of the key for every object exported. If you don't specify a value, the default is `exportedlogs`.
         */
        public var destinationPrefix: kotlin.String? = null
        /**
         * The start time of the range for the request, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp earlier than this time are not exported.
         */
        public var from: kotlin.Long? = null
        /**
         * The name of the log group.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is applied.
         */
        public var logStreamNamePrefix: kotlin.String? = null
        /**
         * The name of the export task.
         */
        public var taskName: kotlin.String? = null
        /**
         * The end time of the range for the request, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`. Events with a timestamp later than this time are not exported.
         *
         * You must specify a time that is not earlier than when this log group was created.
         */
        public var to: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.CreateExportTaskRequest) : this() {
            this.destination = x.destination
            this.destinationPrefix = x.destinationPrefix
            this.from = x.from
            this.logGroupName = x.logGroupName
            this.logStreamNamePrefix = x.logStreamNamePrefix
            this.taskName = x.taskName
            this.to = x.to
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.CreateExportTaskRequest = CreateExportTaskRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
