// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class AssociateKmsKeyRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data. This must be a symmetric KMS key. For more information, see [Amazon Resource Names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms) and [Using Symmetric and Asymmetric Keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html).
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the log group.
     *
     * In your `AssociateKmsKey` operation, you must specify either the `resourceIdentifier` parameter or the `logGroup` parameter, but you can't specify both.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * Specifies the target for this operation. You must specify one of the following:
     * + Specify the following ARN to have future [GetQueryResults](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html) operations in this account encrypt the results with the specified KMS key. Replace *REGION* and *ACCOUNT_ID* with your Region and account ID.`arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:query-result:*`
     * + Specify the ARN of a log group to have CloudWatch Logs use the KMS key to encrypt log events that are ingested and stored by that log group. The log group ARN must be in the following format. Replace *REGION* and *ACCOUNT_ID* with your Region and account ID.`arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:log-group:<i>LOG_GROUP_NAME</i> `
     *
     * In your `AssociateKmsKey` operation, you must specify either the `resourceIdentifier` parameter or the `logGroup` parameter, but you can't specify both.
     */
    public val resourceIdentifier: kotlin.String? = builder.resourceIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.AssociateKmsKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateKmsKeyRequest(")
        append("kmsKeyId=$kmsKeyId,")
        append("logGroupName=$logGroupName,")
        append("resourceIdentifier=$resourceIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateKmsKeyRequest

        if (kmsKeyId != other.kmsKeyId) return false
        if (logGroupName != other.logGroupName) return false
        if (resourceIdentifier != other.resourceIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.AssociateKmsKeyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data. This must be a symmetric KMS key. For more information, see [Amazon Resource Names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms) and [Using Symmetric and Asymmetric Keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html).
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the log group.
         *
         * In your `AssociateKmsKey` operation, you must specify either the `resourceIdentifier` parameter or the `logGroup` parameter, but you can't specify both.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * Specifies the target for this operation. You must specify one of the following:
         * + Specify the following ARN to have future [GetQueryResults](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html) operations in this account encrypt the results with the specified KMS key. Replace *REGION* and *ACCOUNT_ID* with your Region and account ID.`arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:query-result:*`
         * + Specify the ARN of a log group to have CloudWatch Logs use the KMS key to encrypt log events that are ingested and stored by that log group. The log group ARN must be in the following format. Replace *REGION* and *ACCOUNT_ID* with your Region and account ID.`arn:aws:logs:<i>REGION</i>:<i>ACCOUNT_ID</i>:log-group:<i>LOG_GROUP_NAME</i> `
         *
         * In your `AssociateKmsKey` operation, you must specify either the `resourceIdentifier` parameter or the `logGroup` parameter, but you can't specify both.
         */
        public var resourceIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.AssociateKmsKeyRequest) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.logGroupName = x.logGroupName
            this.resourceIdentifier = x.resourceIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.AssociateKmsKeyRequest = AssociateKmsKeyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
