// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.serde

import aws.sdk.kotlin.services.cloudwatchevents.model.ApiDestinationHttpMethod
import aws.sdk.kotlin.services.cloudwatchevents.model.ApiDestinationState
import aws.sdk.kotlin.services.cloudwatchevents.model.CloudWatchEventsException
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeApiDestinationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeApiDestinationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeApiDestinationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeApiDestinationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeApiDestinationError(context, call, payload)
        }
        val builder = DescribeApiDestinationResponse.Builder()

        if (payload != null) {
            deserializeDescribeApiDestinationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeApiDestinationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudWatchEventsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudWatchEventsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeApiDestinationOperationBody(builder: DescribeApiDestinationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIDESTINATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApiDestinationArn"))
    val APIDESTINATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ApiDestinationState"))
    val CONNECTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionArn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val HTTPMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("HttpMethod"))
    val INVOCATIONENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InvocationEndpoint"))
    val INVOCATIONRATELIMITPERSECOND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InvocationRateLimitPerSecond"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIDESTINATIONARN_DESCRIPTOR)
        field(APIDESTINATIONSTATE_DESCRIPTOR)
        field(CONNECTIONARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HTTPMETHOD_DESCRIPTOR)
        field(INVOCATIONENDPOINT_DESCRIPTOR)
        field(INVOCATIONRATELIMITPERSECOND_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIDESTINATIONARN_DESCRIPTOR.index -> builder.apiDestinationArn = deserializeString()
                APIDESTINATIONSTATE_DESCRIPTOR.index -> builder.apiDestinationState = deserializeString().let { ApiDestinationState.fromValue(it) }
                CONNECTIONARN_DESCRIPTOR.index -> builder.connectionArn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                HTTPMETHOD_DESCRIPTOR.index -> builder.httpMethod = deserializeString().let { ApiDestinationHttpMethod.fromValue(it) }
                INVOCATIONENDPOINT_DESCRIPTOR.index -> builder.invocationEndpoint = deserializeString()
                INVOCATIONRATELIMITPERSECOND_DESCRIPTOR.index -> builder.invocationRateLimitPerSecond = deserializeInt()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
