// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Amazon Web Services account that a partner event source has been offered to.
 */
public class PartnerEventSourceAccount private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID that the partner event source was offered to.
     */
    public val account: kotlin.String? = builder.account
    /**
     * The date and time the event source was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The date and time that the event source will expire, if the Amazon Web Services account doesn't create a matching event bus for it.
     */
    public val expirationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationTime
    /**
     * The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event source, and that event bus is active. If it is PENDING, either you haven't yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event source has since been deleted.
     */
    public val state: aws.sdk.kotlin.services.cloudwatchevents.model.EventSourceState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.PartnerEventSourceAccount = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PartnerEventSourceAccount(")
        append("account=$account,")
        append("creationTime=$creationTime,")
        append("expirationTime=$expirationTime,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = account?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PartnerEventSourceAccount

        if (account != other.account) return false
        if (creationTime != other.creationTime) return false
        if (expirationTime != other.expirationTime) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.PartnerEventSourceAccount = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID that the partner event source was offered to.
         */
        public var account: kotlin.String? = null
        /**
         * The date and time the event source was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that the event source will expire, if the Amazon Web Services account doesn't create a matching event bus for it.
         */
        public var expirationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event source, and that event bus is active. If it is PENDING, either you haven't yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event source has since been deleted.
         */
        public var state: aws.sdk.kotlin.services.cloudwatchevents.model.EventSourceState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.PartnerEventSourceAccount) : this() {
            this.account = x.account
            this.creationTime = x.creationTime
            this.expirationTime = x.expirationTime
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.PartnerEventSourceAccount = PartnerEventSourceAccount(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
