// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. In the latter case, these are merged with any InvocationParameters specified on the Connection, with any values from the Connection taking precedence.
 */
public class HttpParameters private constructor(builder: Builder) {
    /**
     * The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
     */
    public val headerParameters: Map<String, String>? = builder.headerParameters
    /**
     * The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
     */
    public val pathParameterValues: List<String>? = builder.pathParameterValues
    /**
     * The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
     */
    public val queryStringParameters: Map<String, String>? = builder.queryStringParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.HttpParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpParameters(")
        append("headerParameters=$headerParameters,")
        append("pathParameterValues=$pathParameterValues,")
        append("queryStringParameters=$queryStringParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headerParameters?.hashCode() ?: 0
        result = 31 * result + (pathParameterValues?.hashCode() ?: 0)
        result = 31 * result + (queryStringParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpParameters

        if (headerParameters != other.headerParameters) return false
        if (pathParameterValues != other.pathParameterValues) return false
        if (queryStringParameters != other.queryStringParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.HttpParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
         */
        public var headerParameters: Map<String, String>? = null
        /**
         * The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
         */
        public var pathParameterValues: List<String>? = null
        /**
         * The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
         */
        public var queryStringParameters: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.HttpParameters) : this() {
            this.headerParameters = x.headerParameters
            this.pathParameterValues = x.pathParameterValues
            this.queryStringParameters = x.queryStringParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.HttpParameters = HttpParameters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
