// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the OAuth authorization parameters to use for the connection.
 */
public class CreateConnectionOAuthRequestParameters private constructor(builder: Builder) {
    /**
     * The URL to the authorization endpoint when OAuth is specified as the authorization type.
     */
    public val authorizationEndpoint: kotlin.String = requireNotNull(builder.authorizationEndpoint) { "A non-null value must be provided for authorizationEndpoint" }
    /**
     * A `CreateConnectionOAuthClientRequestParameters` object that contains the client parameters for OAuth authorization.
     */
    public val clientParameters: aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionOAuthClientRequestParameters? = builder.clientParameters
    /**
     * The method to use for the authorization request.
     */
    public val httpMethod: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthHttpMethod = requireNotNull(builder.httpMethod) { "A non-null value must be provided for httpMethod" }
    /**
     * A `ConnectionHttpParameters` object that contains details about the additional parameters to use for the connection.
     */
    public val oAuthHttpParameters: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters? = builder.oAuthHttpParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionOAuthRequestParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConnectionOAuthRequestParameters(")
        append("authorizationEndpoint=$authorizationEndpoint,")
        append("clientParameters=$clientParameters,")
        append("httpMethod=$httpMethod,")
        append("oAuthHttpParameters=$oAuthHttpParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizationEndpoint.hashCode()
        result = 31 * result + (clientParameters?.hashCode() ?: 0)
        result = 31 * result + (httpMethod.hashCode())
        result = 31 * result + (oAuthHttpParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConnectionOAuthRequestParameters

        if (authorizationEndpoint != other.authorizationEndpoint) return false
        if (clientParameters != other.clientParameters) return false
        if (httpMethod != other.httpMethod) return false
        if (oAuthHttpParameters != other.oAuthHttpParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionOAuthRequestParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The URL to the authorization endpoint when OAuth is specified as the authorization type.
         */
        public var authorizationEndpoint: kotlin.String? = null
        /**
         * A `CreateConnectionOAuthClientRequestParameters` object that contains the client parameters for OAuth authorization.
         */
        public var clientParameters: aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionOAuthClientRequestParameters? = null
        /**
         * The method to use for the authorization request.
         */
        public var httpMethod: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthHttpMethod? = null
        /**
         * A `ConnectionHttpParameters` object that contains details about the additional parameters to use for the connection.
         */
        public var oAuthHttpParameters: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionOAuthRequestParameters) : this() {
            this.authorizationEndpoint = x.authorizationEndpoint
            this.clientParameters = x.clientParameters
            this.httpMethod = x.httpMethod
            this.oAuthHttpParameters = x.oAuthHttpParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionOAuthRequestParameters = CreateConnectionOAuthRequestParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionOAuthClientRequestParameters] inside the given [block]
         */
        public fun clientParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionOAuthClientRequestParameters.Builder.() -> kotlin.Unit) {
            this.clientParameters = aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionOAuthClientRequestParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters] inside the given [block]
         */
        public fun oAuthHttpParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters.Builder.() -> kotlin.Unit) {
            this.oAuthHttpParameters = aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (authorizationEndpoint == null) authorizationEndpoint = ""
            if (httpMethod == null) httpMethod = ConnectionOAuthHttpMethod.SdkUnknown("no value provided")
            return this
        }
    }
}
