// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details of a capacity provider strategy. To learn more, see [CapacityProviderStrategyItem](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html) in the Amazon ECS API Reference.
 */
public class CapacityProviderStrategyItem private constructor(builder: Builder) {
    /**
     * The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
     */
    public val base: kotlin.Int = builder.base
    /**
     * The short name of the capacity provider.
     */
    public val capacityProvider: kotlin.String = requireNotNull(builder.capacityProvider) { "A non-null value must be provided for capacityProvider" }
    /**
     * The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
     */
    public val weight: kotlin.Int = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.CapacityProviderStrategyItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityProviderStrategyItem(")
        append("base=$base,")
        append("capacityProvider=$capacityProvider,")
        append("weight=$weight")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = base
        result = 31 * result + (capacityProvider.hashCode())
        result = 31 * result + (weight)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityProviderStrategyItem

        if (base != other.base) return false
        if (capacityProvider != other.capacityProvider) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.CapacityProviderStrategyItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
         */
        public var base: kotlin.Int = 0
        /**
         * The short name of the capacity provider.
         */
        public var capacityProvider: kotlin.String? = null
        /**
         * The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
         */
        public var weight: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.CapacityProviderStrategyItem) : this() {
            this.base = x.base
            this.capacityProvider = x.capacityProvider
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.CapacityProviderStrategyItem = CapacityProviderStrategyItem(this)

        internal fun correctErrors(): Builder {
            if (capacityProvider == null) capacityProvider = ""
            return this
        }
    }
}
