// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.cloudwatchevents.auth.CloudWatchEventsAuthSchemeProvider
import aws.sdk.kotlin.services.cloudwatchevents.auth.DefaultCloudWatchEventsAuthSchemeProvider
import aws.sdk.kotlin.services.cloudwatchevents.endpoints.CloudWatchEventsEndpointParameters
import aws.sdk.kotlin.services.cloudwatchevents.endpoints.CloudWatchEventsEndpointProvider
import aws.sdk.kotlin.services.cloudwatchevents.endpoints.DefaultCloudWatchEventsEndpointProvider
import aws.sdk.kotlin.services.cloudwatchevents.model.ActivateEventSourceRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ActivateEventSourceResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.CancelReplayRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.CancelReplayResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.CreateApiDestinationRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.CreateApiDestinationResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.CreateArchiveRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.CreateArchiveResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.CreateConnectionResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.CreateEventBusRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.CreateEventBusResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.CreatePartnerEventSourceRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.CreatePartnerEventSourceResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DeactivateEventSourceRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DeactivateEventSourceResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DeauthorizeConnectionRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DeauthorizeConnectionResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteApiDestinationRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteApiDestinationResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteArchiveRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteArchiveResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteConnectionResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteEventBusRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteEventBusResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DeletePartnerEventSourceRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DeletePartnerEventSourceResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteRuleRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DeleteRuleResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeApiDestinationRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeApiDestinationResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeArchiveRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeArchiveResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeConnectionRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeConnectionResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeEventBusRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeEventBusResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeEventSourceRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeEventSourceResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribePartnerEventSourceRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribePartnerEventSourceResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeReplayRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeReplayResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeRuleRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DescribeRuleResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.DisableRuleRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.DisableRuleResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.EnableRuleRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.EnableRuleResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListApiDestinationsRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListApiDestinationsResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListArchivesRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListArchivesResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListConnectionsRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListConnectionsResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListEventBusesRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListEventBusesResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListEventSourcesRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListEventSourcesResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListPartnerEventSourceAccountsRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListPartnerEventSourceAccountsResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListPartnerEventSourcesRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListPartnerEventSourcesResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListReplaysRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListReplaysResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListRuleNamesByTargetRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListRuleNamesByTargetResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListRulesRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListRulesResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.ListTargetsByRuleRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.ListTargetsByRuleResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.PutEventsRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.PutEventsResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.PutPartnerEventsRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.PutPartnerEventsResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.PutPermissionRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.PutPermissionResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.PutRuleRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.PutRuleResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.PutTargetsRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.PutTargetsResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.RemovePermissionRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.RemovePermissionResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.RemoveTargetsRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.RemoveTargetsResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.StartReplayRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.StartReplayResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.TagResourceRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.TagResourceResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.TestEventPatternRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.TestEventPatternResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.UntagResourceRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.UntagResourceResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.UpdateApiDestinationRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.UpdateApiDestinationResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.UpdateArchiveRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.UpdateArchiveResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.UpdateConnectionRequest
import aws.sdk.kotlin.services.cloudwatchevents.model.UpdateConnectionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "CloudWatch Events"
public const val SdkVersion: String = "1.3.13"
public const val ServiceApiVersion: String = "2015-10-07"

/**
 * Amazon EventBridge helps you to respond to state changes in your Amazon Web Services resources. When your resources change state, they automatically send events to an event stream. You can create rules that match selected events in the stream and route them to targets to take action. You can also use rules to take action on a predetermined schedule. For example, you can configure rules to:
 * + Automatically invoke an Lambda function to update DNS entries when an event notifies you that Amazon EC2 instance enters the running state.
 * + Direct specific API records from CloudTrail to an Amazon Kinesis data stream for detailed analysis of potential security or availability risks.
 * + Periodically invoke a built-in target to create a snapshot of an Amazon EBS volume.
 *
 * For more information about the features of Amazon EventBridge, see the [Amazon EventBridge User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide).
 */
public interface CloudWatchEventsClient : SdkClient {
    /**
     * CloudWatchEventsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CloudWatchEventsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CloudWatchEvents",
                "CLOUDWATCH_EVENTS",
                "cloudwatch_events",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CloudWatchEventsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CloudWatchEventsClient = DefaultCloudWatchEventsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CloudWatchEventsEndpointProvider = builder.endpointProvider ?: DefaultCloudWatchEventsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CloudWatchEventsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCloudWatchEventsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CloudWatch Events"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CloudWatchEventsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CloudWatchEventsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Activates a partner event source that has been deactivated. Once activated, your matching event bus will start receiving events from the event source.
     */
    public suspend fun activateEventSource(input: ActivateEventSourceRequest): ActivateEventSourceResponse

    /**
     * Cancels the specified replay.
     */
    public suspend fun cancelReplay(input: CancelReplayRequest): CancelReplayResponse

    /**
     * Creates an API destination, which is an HTTP invocation endpoint configured as a target for events.
     */
    public suspend fun createApiDestination(input: CreateApiDestinationRequest): CreateApiDestinationResponse

    /**
     * Creates an archive of events with the specified settings. When you create an archive, incoming events might not immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed events. Replayed events are not sent to an archive.
     */
    public suspend fun createArchive(input: CreateArchiveRequest): CreateArchiveResponse

    /**
     * Creates a connection. A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.
     */
    public suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse

    /**
     * Creates a new event bus within your account. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.
     */
    public suspend fun createEventBus(input: CreateEventBusRequest): CreateEventBusResponse

    /**
     * Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services customers.
     *
     * Each partner event source can be used by one Amazon Web Services account to create a matching partner event bus in that Amazon Web Services account. A SaaS partner must create one partner event source for each Amazon Web Services account that wants to receive those event types.
     *
     * A partner event source creates events based on resources within the SaaS partner's service or application.
     *
     * An Amazon Web Services account that creates a partner event bus that matches the partner event source can use that event bus to receive events from the partner, and then process them using Amazon Web Services Events rules and targets.
     *
     * Partner event source names follow this format:
     *
     * ` <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> `
     *
     * *partner_name* is determined during partner registration and identifies the partner to Amazon Web Services customers. *event_namespace* is determined by the partner and is a way for the partner to categorize their events. *event_name* is determined by the partner, and should uniquely identify an event-generating resource within the partner system. The combination of *event_namespace* and *event_name* should help Amazon Web Services customers decide whether to create an event bus to receive these events.
     */
    public suspend fun createPartnerEventSource(input: CreatePartnerEventSourceRequest): CreatePartnerEventSourceResponse

    /**
     * You can use this operation to temporarily stop receiving events from the specified partner event source. The matching event bus is not deleted.
     *
     * When you deactivate a partner event source, the source goes into PENDING state. If it remains in PENDING state for more than two weeks, it is deleted.
     *
     * To activate a deactivated partner event source, use [ActivateEventSource](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html).
     */
    public suspend fun deactivateEventSource(input: DeactivateEventSourceRequest): DeactivateEventSourceResponse

    /**
     * Removes all authorization parameters from the connection. This lets you remove the secret from the connection so you can reuse it without having to create a new connection.
     */
    public suspend fun deauthorizeConnection(input: DeauthorizeConnectionRequest): DeauthorizeConnectionResponse

    /**
     * Deletes the specified API destination.
     */
    public suspend fun deleteApiDestination(input: DeleteApiDestinationRequest): DeleteApiDestinationResponse

    /**
     * Deletes the specified archive.
     */
    public suspend fun deleteArchive(input: DeleteArchiveRequest): DeleteArchiveResponse

    /**
     * Deletes a connection.
     */
    public suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be deleted. You can't delete your account's default event bus.
     */
    public suspend fun deleteEventBus(input: DeleteEventBusRequest): DeleteEventBusResponse

    /**
     * This operation is used by SaaS partners to delete a partner event source. This operation is not used by Amazon Web Services customers.
     *
     * When you delete an event source, the status of the corresponding partner event bus in the Amazon Web Services customer account becomes DELETED.
     */
    public suspend fun deletePartnerEventSource(input: DeletePartnerEventSourceRequest): DeletePartnerEventSourceResponse

    /**
     * Deletes the specified rule.
     *
     * Before you can delete the rule, you must remove all targets, using [RemoveTargets](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html).
     *
     * When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time for changes to take effect.
     *
     * If you call delete rule multiple times for the same rule, all calls will succeed. When you call delete rule for a non-existent custom eventbus, `ResourceNotFoundException` is returned.
     *
     * Managed rules are rules created and managed by another Amazon Web Services service on your behalf. These rules are created by those other Amazon Web Services services to support functionality in those services. You can delete these rules using the `Force` option, but you should do so only if you are sure the other service is not still using that rule.
     */
    public suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse

    /**
     * Retrieves details about an API destination.
     */
    public suspend fun describeApiDestination(input: DescribeApiDestinationRequest): DescribeApiDestinationResponse

    /**
     * Retrieves details about an archive.
     */
    public suspend fun describeArchive(input: DescribeArchiveRequest): DescribeArchiveResponse

    /**
     * Retrieves details about a connection.
     */
    public suspend fun describeConnection(input: DescribeConnectionRequest): DescribeConnectionResponse

    /**
     * Displays details about an event bus in your account. This can include the external Amazon Web Services accounts that are permitted to write events to your default event bus, and the associated policy. For custom event buses and partner event buses, it displays the name, ARN, policy, state, and creation time.
     *
     *  To enable your account to receive events from other accounts on its default event bus, use [PutPermission](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html).
     *
     * For more information about partner event buses, see [CreateEventBus](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html).
     */
    public suspend fun describeEventBus(input: DescribeEventBusRequest = DescribeEventBusRequest { }): DescribeEventBusResponse

    /**
     * This operation lists details about a partner event source that is shared with your account.
     */
    public suspend fun describeEventSource(input: DescribeEventSourceRequest): DescribeEventSourceResponse

    /**
     * An SaaS partner can use this operation to list details about a partner event source that they have created. Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use [DescribeEventSource](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html) to see details about a partner event source that is shared with them.
     */
    public suspend fun describePartnerEventSource(input: DescribePartnerEventSourceRequest): DescribePartnerEventSourceResponse

    /**
     * Retrieves details about a replay. Use `DescribeReplay` to determine the progress of a running replay. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you use `StartReplay` and specify an `EventStartTime` and an `EventEndTime` that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use `DescribeReplay` to determine the progress of a replay. The value returned for `EventLastReplayedTime` indicates the time within the specified time range associated with the last event replayed.
     */
    public suspend fun describeReplay(input: DescribeReplayRequest): DescribeReplayResponse

    /**
     * Describes the specified rule.
     *
     * DescribeRule does not list the targets of a rule. To see the targets associated with a rule, use [ListTargetsByRule](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html).
     */
    public suspend fun describeRule(input: DescribeRuleRequest): DescribeRuleResponse

    /**
     * Disables the specified rule. A disabled rule won't match any events, and won't self-trigger if it has a schedule expression.
     *
     * When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of time for changes to take effect.
     */
    public suspend fun disableRule(input: DisableRuleRequest): DisableRuleResponse

    /**
     * Enables the specified rule. If the rule does not exist, the operation fails.
     *
     * When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a short period of time for changes to take effect.
     */
    public suspend fun enableRule(input: EnableRuleRequest): EnableRuleResponse

    /**
     * Retrieves a list of API destination in the account in the current Region.
     */
    public suspend fun listApiDestinations(input: ListApiDestinationsRequest = ListApiDestinationsRequest { }): ListApiDestinationsResponse

    /**
     * Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive names. Filter parameters are exclusive.
     */
    public suspend fun listArchives(input: ListArchivesRequest = ListArchivesRequest { }): ListArchivesResponse

    /**
     * Retrieves a list of connections from the account.
     */
    public suspend fun listConnections(input: ListConnectionsRequest = ListConnectionsRequest { }): ListConnectionsResponse

    /**
     * Lists all the event buses in your account, including the default event bus, custom event buses, and partner event buses.
     */
    public suspend fun listEventBuses(input: ListEventBusesRequest = ListEventBusesRequest { }): ListEventBusesResponse

    /**
     * You can use this to see all the partner event sources that have been shared with your Amazon Web Services account. For more information about partner event sources, see [CreateEventBus](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html).
     */
    public suspend fun listEventSources(input: ListEventSourcesRequest = ListEventSourcesRequest { }): ListEventSourcesResponse

    /**
     * An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular partner event source name is associated with. This operation is not used by Amazon Web Services customers.
     */
    public suspend fun listPartnerEventSourceAccounts(input: ListPartnerEventSourceAccountsRequest): ListPartnerEventSourceAccountsResponse

    /**
     * An SaaS partner can use this operation to list all the partner event source names that they have created. This operation is not used by Amazon Web Services customers.
     */
    public suspend fun listPartnerEventSources(input: ListPartnerEventSourcesRequest): ListPartnerEventSourcesResponse

    /**
     * Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names. Filter parameters are exclusive.
     */
    public suspend fun listReplays(input: ListReplaysRequest = ListReplaysRequest { }): ListReplaysResponse

    /**
     * Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a specific target in your account.
     */
    public suspend fun listRuleNamesByTarget(input: ListRuleNamesByTargetRequest): ListRuleNamesByTargetResponse

    /**
     * Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to the rule names.
     *
     * ListRules does not list the targets of a rule. To see the targets associated with a rule, use [ListTargetsByRule](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html).
     */
    public suspend fun listRules(input: ListRulesRequest = ListRulesRequest { }): ListRulesResponse

    /**
     * Displays the tags associated with an EventBridge resource. In EventBridge, rules and event buses can be tagged.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the targets assigned to the specified rule.
     */
    public suspend fun listTargetsByRule(input: ListTargetsByRuleRequest): ListTargetsByRuleResponse

    /**
     * Sends custom events to Amazon EventBridge so that they can be matched to rules.
     */
    public suspend fun putEvents(input: PutEventsRequest): PutEventsResponse

    /**
     * This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services customers do not use this operation.
     */
    public suspend fun putPartnerEvents(input: PutPartnerEventsRequest): PutPartnerEventsResponse

    /**
     * Running `PutPermission` permits the specified Amazon Web Services account or Amazon Web Services organization to put events to the specified *event bus*. Amazon EventBridge (CloudWatch Events) rules in your account are triggered by these events arriving to an event bus in your account.
     *
     * For another account to send events to your account, that external account must have an EventBridge rule with your account's event bus as a target.
     *
     * To enable multiple Amazon Web Services accounts to put events to your event bus, run `PutPermission` once for each of these accounts. Or, if all the accounts are members of the same Amazon Web Services organization, you can run `PutPermission` once specifying `Principal` as "*" and specifying the Amazon Web Services organization ID in `Condition`, to grant permissions to all accounts in that organization.
     *
     * If you grant permissions using an organization, then accounts in that organization must specify a `RoleArn` with proper permissions when they use `PutTarget` to add your account's event bus as a target. For more information, see [Sending and Receiving Events Between Amazon Web Services Accounts](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html) in the *Amazon EventBridge User Guide*.
     *
     * The permission policy on the event bus cannot exceed 10 KB in size.
     */
    public suspend fun putPermission(input: PutPermissionRequest = PutPermissionRequest { }): PutPermissionResponse

    /**
     * Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can disable a rule using [DisableRule](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html).
     *
     * A single rule watches for events from a single event bus. Events generated by Amazon Web Services services go to your account's default event bus. Events generated by SaaS partner services or applications go to the matching partner event bus. If you have custom applications or services, you can specify whether their events go to your default event bus or a custom event bus that you have created. For more information, see [CreateEventBus](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html).
     *
     * If you are updating an existing rule, the rule is replaced with what you specify in this `PutRule` command. If you omit arguments in `PutRule`, the old values for those arguments are not kept. Instead, they are replaced with null values.
     *
     * When you create or update a rule, incoming events might not immediately start matching to new or updated rules. Allow a short period of time for changes to take effect.
     *
     * A rule must contain at least an EventPattern or ScheduleExpression. Rules with EventPatterns are triggered when a matching event is observed. Rules with ScheduleExpressions self-trigger based on the given schedule. A rule can have both an EventPattern and a ScheduleExpression, in which case the rule triggers on matching events as well as on a schedule.
     *
     * When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only rules with certain tag values. To use the `PutRule` operation and assign tags, you must have both the `events:PutRule` and `events:TagResource` permissions.
     *
     * If you are updating an existing rule, any tags you specify in the `PutRule` operation are ignored. To update the tags of an existing rule, use [TagResource](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html) and [UntagResource](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html).
     *
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.
     *
     * In EventBridge, it is possible to create rules that lead to infinite loops, where a rule is fired repeatedly. For example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the desired state. If the rule is not written carefully, the subsequent change to the ACLs fires the rule again, creating an infinite loop.
     *
     * To prevent this, write the rules so that the triggered actions do not re-fire the same rule. For example, your rule could fire only if ACLs are found to be in a bad state, instead of after any change.
     *
     * An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which alerts you when charges exceed your specified limit. For more information, see [Managing Your Costs with Budgets](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html).
     */
    public suspend fun putRule(input: PutRuleRequest): PutRuleResponse

    /**
     * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
     *
     * Targets are the resources that are invoked when a rule is triggered.
     *
     * You can configure the following as targets for Events:
     * + [API destination](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html)
     * + Amazon API Gateway REST API endpoints
     * + API Gateway
     * + Batch job queue
     * + CloudWatch Logs group
     * + CodeBuild project
     * + CodePipeline
     * + Amazon EC2 `CreateSnapshot` API call
     * + Amazon EC2 `RebootInstances` API call
     * + Amazon EC2 `StopInstances` API call
     * + Amazon EC2 `TerminateInstances` API call
     * + Amazon ECS tasks
     * + Event bus in a different Amazon Web Services account or Region.You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon) us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.
     * + Firehose delivery stream (Kinesis Data Firehose)
     * + Inspector assessment template (Amazon Inspector)
     * + Kinesis stream (Kinesis Data Stream)
     * + Lambda function
     * + Redshift clusters (Data API statement execution)
     * + Amazon SNS topic
     * + Amazon SQS queues (includes FIFO queues
     * + SSM Automation
     * + SSM OpsItem
     * + SSM Run Command
     * + Step Functions state machines
     *
     * Creating rules with built-in targets is supported only in the Amazon Web Services Management Console. The built-in targets are `EC2 CreateSnapshot API call`, `EC2 RebootInstances API call`, `EC2 StopInstances API call`, and `EC2 TerminateInstances API call`.
     *
     * For some target types, `PutTargets` provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the `KinesisParameters` argument. To invoke a command on multiple EC2 instances with one rule, you can use the `RunCommandParameters` field.
     *
     * To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions. For Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams, Step Functions state machines and API Gateway REST APIs, EventBridge relies on IAM roles that you specify in the `RoleARN` argument in `PutTargets`. For more information, see [Authentication and Access Control](https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html) in the *Amazon EventBridge User Guide*.
     *
     * If another Amazon Web Services account is in the same region and has granted you permission (using `PutPermission`), you can send events to that account. Set that account's event bus as a target of the rules in your account. To send the matched events to the other account, specify that account's event bus as the `Arn` value when you run `PutTargets`. If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see [Amazon EventBridge Pricing](http://aws.amazon.com/eventbridge/pricing/).
     *
     * `Input`, `InputPath`, and `InputTransformer` are not available with `PutTarget` if the target is an event bus of a different Amazon Web Services account.
     *
     * If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a `RoleArn` with proper permissions in the `Target` structure. For more information, see [Sending and Receiving Events Between Amazon Web Services Accounts](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html) in the *Amazon EventBridge User Guide*.
     *
     * For more information about enabling cross-account events, see [PutPermission](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html).
     *
     * **Input**, **InputPath**, and **InputTransformer** are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:
     * + If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).
     * + If **Input** is specified in the form of valid JSON, then the matched event is overridden with this constant.
     * + If **InputPath** is specified in the form of JSONPath (for example, `$.detail`), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).
     * + If **InputTransformer** is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.
     *
     * When you specify `InputPath` or `InputTransformer`, you must use JSON dot notation, not bracket notation.
     *
     * When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.
     *
     * This action can partially fail if too many requests are made at the same time. If that happens, `FailedEntryCount` is non-zero in the response and each entry in `FailedEntries` provides the ID of the failed target and the error code.
     */
    public suspend fun putTargets(input: PutTargetsRequest): PutTargetsResponse

    /**
     * Revokes the permission of another Amazon Web Services account to be able to put events to the specified event bus. Specify the account to revoke by the `StatementId` value that you associated with the account when you granted it permission with `PutPermission`. You can find the `StatementId` by using [DescribeEventBus](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html).
     */
    public suspend fun removePermission(input: RemovePermissionRequest = RemovePermissionRequest { }): RemovePermissionResponse

    /**
     * Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be invoked.
     *
     * When you remove a target, when the associated rule triggers, removed targets might continue to be invoked. Allow a short period of time for changes to take effect.
     *
     * This action can partially fail if too many requests are made at the same time. If that happens, `FailedEntryCount` is non-zero in the response and each entry in `FailedEntries` provides the ID of the failed target and the error code.
     */
    public suspend fun removeTargets(input: RemoveTargetsRequest): RemoveTargetsResponse

    /**
     * Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you specify an `EventStartTime` and an `EventEndTime` that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use `DescribeReplay` to determine the progress of a replay. The value returned for `EventLastReplayedTime` indicates the time within the specified time range associated with the last event replayed.
     */
    public suspend fun startReplay(input: StartReplayRequest): StartReplayResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In EventBridge, rules and event buses can be tagged.
     *
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
     *
     * You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tests whether the specified event pattern matches the provided event.
     *
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.
     */
    public suspend fun testEventPattern(input: TestEventPatternRequest): TestEventPatternResponse

    /**
     * Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge (CloudWatch Events), rules and event buses can be tagged.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an API destination.
     */
    public suspend fun updateApiDestination(input: UpdateApiDestinationRequest): UpdateApiDestinationResponse

    /**
     * Updates the specified archive.
     */
    public suspend fun updateArchive(input: UpdateArchiveRequest): UpdateArchiveResponse

    /**
     * Updates settings for a connection.
     */
    public suspend fun updateConnection(input: UpdateConnectionRequest): UpdateConnectionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CloudWatchEventsClient.withConfig(block: CloudWatchEventsClient.Config.Builder.() -> Unit): CloudWatchEventsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCloudWatchEventsClient(newConfig)
}

/**
 * Activates a partner event source that has been deactivated. Once activated, your matching event bus will start receiving events from the event source.
 */
public suspend inline fun CloudWatchEventsClient.activateEventSource(crossinline block: ActivateEventSourceRequest.Builder.() -> Unit): ActivateEventSourceResponse = activateEventSource(ActivateEventSourceRequest.Builder().apply(block).build())

/**
 * Cancels the specified replay.
 */
public suspend inline fun CloudWatchEventsClient.cancelReplay(crossinline block: CancelReplayRequest.Builder.() -> Unit): CancelReplayResponse = cancelReplay(CancelReplayRequest.Builder().apply(block).build())

/**
 * Creates an API destination, which is an HTTP invocation endpoint configured as a target for events.
 */
public suspend inline fun CloudWatchEventsClient.createApiDestination(crossinline block: CreateApiDestinationRequest.Builder.() -> Unit): CreateApiDestinationResponse = createApiDestination(CreateApiDestinationRequest.Builder().apply(block).build())

/**
 * Creates an archive of events with the specified settings. When you create an archive, incoming events might not immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed events. Replayed events are not sent to an archive.
 */
public suspend inline fun CloudWatchEventsClient.createArchive(crossinline block: CreateArchiveRequest.Builder.() -> Unit): CreateArchiveResponse = createArchive(CreateArchiveRequest.Builder().apply(block).build())

/**
 * Creates a connection. A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.
 */
public suspend inline fun CloudWatchEventsClient.createConnection(crossinline block: CreateConnectionRequest.Builder.() -> Unit): CreateConnectionResponse = createConnection(CreateConnectionRequest.Builder().apply(block).build())

/**
 * Creates a new event bus within your account. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.
 */
public suspend inline fun CloudWatchEventsClient.createEventBus(crossinline block: CreateEventBusRequest.Builder.() -> Unit): CreateEventBusResponse = createEventBus(CreateEventBusRequest.Builder().apply(block).build())

/**
 * Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services customers.
 *
 * Each partner event source can be used by one Amazon Web Services account to create a matching partner event bus in that Amazon Web Services account. A SaaS partner must create one partner event source for each Amazon Web Services account that wants to receive those event types.
 *
 * A partner event source creates events based on resources within the SaaS partner's service or application.
 *
 * An Amazon Web Services account that creates a partner event bus that matches the partner event source can use that event bus to receive events from the partner, and then process them using Amazon Web Services Events rules and targets.
 *
 * Partner event source names follow this format:
 *
 * ` <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> `
 *
 * *partner_name* is determined during partner registration and identifies the partner to Amazon Web Services customers. *event_namespace* is determined by the partner and is a way for the partner to categorize their events. *event_name* is determined by the partner, and should uniquely identify an event-generating resource within the partner system. The combination of *event_namespace* and *event_name* should help Amazon Web Services customers decide whether to create an event bus to receive these events.
 */
public suspend inline fun CloudWatchEventsClient.createPartnerEventSource(crossinline block: CreatePartnerEventSourceRequest.Builder.() -> Unit): CreatePartnerEventSourceResponse = createPartnerEventSource(CreatePartnerEventSourceRequest.Builder().apply(block).build())

/**
 * You can use this operation to temporarily stop receiving events from the specified partner event source. The matching event bus is not deleted.
 *
 * When you deactivate a partner event source, the source goes into PENDING state. If it remains in PENDING state for more than two weeks, it is deleted.
 *
 * To activate a deactivated partner event source, use [ActivateEventSource](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html).
 */
public suspend inline fun CloudWatchEventsClient.deactivateEventSource(crossinline block: DeactivateEventSourceRequest.Builder.() -> Unit): DeactivateEventSourceResponse = deactivateEventSource(DeactivateEventSourceRequest.Builder().apply(block).build())

/**
 * Removes all authorization parameters from the connection. This lets you remove the secret from the connection so you can reuse it without having to create a new connection.
 */
public suspend inline fun CloudWatchEventsClient.deauthorizeConnection(crossinline block: DeauthorizeConnectionRequest.Builder.() -> Unit): DeauthorizeConnectionResponse = deauthorizeConnection(DeauthorizeConnectionRequest.Builder().apply(block).build())

/**
 * Deletes the specified API destination.
 */
public suspend inline fun CloudWatchEventsClient.deleteApiDestination(crossinline block: DeleteApiDestinationRequest.Builder.() -> Unit): DeleteApiDestinationResponse = deleteApiDestination(DeleteApiDestinationRequest.Builder().apply(block).build())

/**
 * Deletes the specified archive.
 */
public suspend inline fun CloudWatchEventsClient.deleteArchive(crossinline block: DeleteArchiveRequest.Builder.() -> Unit): DeleteArchiveResponse = deleteArchive(DeleteArchiveRequest.Builder().apply(block).build())

/**
 * Deletes a connection.
 */
public suspend inline fun CloudWatchEventsClient.deleteConnection(crossinline block: DeleteConnectionRequest.Builder.() -> Unit): DeleteConnectionResponse = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

/**
 * Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be deleted. You can't delete your account's default event bus.
 */
public suspend inline fun CloudWatchEventsClient.deleteEventBus(crossinline block: DeleteEventBusRequest.Builder.() -> Unit): DeleteEventBusResponse = deleteEventBus(DeleteEventBusRequest.Builder().apply(block).build())

/**
 * This operation is used by SaaS partners to delete a partner event source. This operation is not used by Amazon Web Services customers.
 *
 * When you delete an event source, the status of the corresponding partner event bus in the Amazon Web Services customer account becomes DELETED.
 */
public suspend inline fun CloudWatchEventsClient.deletePartnerEventSource(crossinline block: DeletePartnerEventSourceRequest.Builder.() -> Unit): DeletePartnerEventSourceResponse = deletePartnerEventSource(DeletePartnerEventSourceRequest.Builder().apply(block).build())

/**
 * Deletes the specified rule.
 *
 * Before you can delete the rule, you must remove all targets, using [RemoveTargets](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html).
 *
 * When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time for changes to take effect.
 *
 * If you call delete rule multiple times for the same rule, all calls will succeed. When you call delete rule for a non-existent custom eventbus, `ResourceNotFoundException` is returned.
 *
 * Managed rules are rules created and managed by another Amazon Web Services service on your behalf. These rules are created by those other Amazon Web Services services to support functionality in those services. You can delete these rules using the `Force` option, but you should do so only if you are sure the other service is not still using that rule.
 */
public suspend inline fun CloudWatchEventsClient.deleteRule(crossinline block: DeleteRuleRequest.Builder.() -> Unit): DeleteRuleResponse = deleteRule(DeleteRuleRequest.Builder().apply(block).build())

/**
 * Retrieves details about an API destination.
 */
public suspend inline fun CloudWatchEventsClient.describeApiDestination(crossinline block: DescribeApiDestinationRequest.Builder.() -> Unit): DescribeApiDestinationResponse = describeApiDestination(DescribeApiDestinationRequest.Builder().apply(block).build())

/**
 * Retrieves details about an archive.
 */
public suspend inline fun CloudWatchEventsClient.describeArchive(crossinline block: DescribeArchiveRequest.Builder.() -> Unit): DescribeArchiveResponse = describeArchive(DescribeArchiveRequest.Builder().apply(block).build())

/**
 * Retrieves details about a connection.
 */
public suspend inline fun CloudWatchEventsClient.describeConnection(crossinline block: DescribeConnectionRequest.Builder.() -> Unit): DescribeConnectionResponse = describeConnection(DescribeConnectionRequest.Builder().apply(block).build())

/**
 * Displays details about an event bus in your account. This can include the external Amazon Web Services accounts that are permitted to write events to your default event bus, and the associated policy. For custom event buses and partner event buses, it displays the name, ARN, policy, state, and creation time.
 *
 *  To enable your account to receive events from other accounts on its default event bus, use [PutPermission](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html).
 *
 * For more information about partner event buses, see [CreateEventBus](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html).
 */
public suspend inline fun CloudWatchEventsClient.describeEventBus(crossinline block: DescribeEventBusRequest.Builder.() -> Unit): DescribeEventBusResponse = describeEventBus(DescribeEventBusRequest.Builder().apply(block).build())

/**
 * This operation lists details about a partner event source that is shared with your account.
 */
public suspend inline fun CloudWatchEventsClient.describeEventSource(crossinline block: DescribeEventSourceRequest.Builder.() -> Unit): DescribeEventSourceResponse = describeEventSource(DescribeEventSourceRequest.Builder().apply(block).build())

/**
 * An SaaS partner can use this operation to list details about a partner event source that they have created. Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use [DescribeEventSource](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html) to see details about a partner event source that is shared with them.
 */
public suspend inline fun CloudWatchEventsClient.describePartnerEventSource(crossinline block: DescribePartnerEventSourceRequest.Builder.() -> Unit): DescribePartnerEventSourceResponse = describePartnerEventSource(DescribePartnerEventSourceRequest.Builder().apply(block).build())

/**
 * Retrieves details about a replay. Use `DescribeReplay` to determine the progress of a running replay. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you use `StartReplay` and specify an `EventStartTime` and an `EventEndTime` that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use `DescribeReplay` to determine the progress of a replay. The value returned for `EventLastReplayedTime` indicates the time within the specified time range associated with the last event replayed.
 */
public suspend inline fun CloudWatchEventsClient.describeReplay(crossinline block: DescribeReplayRequest.Builder.() -> Unit): DescribeReplayResponse = describeReplay(DescribeReplayRequest.Builder().apply(block).build())

/**
 * Describes the specified rule.
 *
 * DescribeRule does not list the targets of a rule. To see the targets associated with a rule, use [ListTargetsByRule](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html).
 */
public suspend inline fun CloudWatchEventsClient.describeRule(crossinline block: DescribeRuleRequest.Builder.() -> Unit): DescribeRuleResponse = describeRule(DescribeRuleRequest.Builder().apply(block).build())

/**
 * Disables the specified rule. A disabled rule won't match any events, and won't self-trigger if it has a schedule expression.
 *
 * When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of time for changes to take effect.
 */
public suspend inline fun CloudWatchEventsClient.disableRule(crossinline block: DisableRuleRequest.Builder.() -> Unit): DisableRuleResponse = disableRule(DisableRuleRequest.Builder().apply(block).build())

/**
 * Enables the specified rule. If the rule does not exist, the operation fails.
 *
 * When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a short period of time for changes to take effect.
 */
public suspend inline fun CloudWatchEventsClient.enableRule(crossinline block: EnableRuleRequest.Builder.() -> Unit): EnableRuleResponse = enableRule(EnableRuleRequest.Builder().apply(block).build())

/**
 * Retrieves a list of API destination in the account in the current Region.
 */
public suspend inline fun CloudWatchEventsClient.listApiDestinations(crossinline block: ListApiDestinationsRequest.Builder.() -> Unit): ListApiDestinationsResponse = listApiDestinations(ListApiDestinationsRequest.Builder().apply(block).build())

/**
 * Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive names. Filter parameters are exclusive.
 */
public suspend inline fun CloudWatchEventsClient.listArchives(crossinline block: ListArchivesRequest.Builder.() -> Unit): ListArchivesResponse = listArchives(ListArchivesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of connections from the account.
 */
public suspend inline fun CloudWatchEventsClient.listConnections(crossinline block: ListConnectionsRequest.Builder.() -> Unit): ListConnectionsResponse = listConnections(ListConnectionsRequest.Builder().apply(block).build())

/**
 * Lists all the event buses in your account, including the default event bus, custom event buses, and partner event buses.
 */
public suspend inline fun CloudWatchEventsClient.listEventBuses(crossinline block: ListEventBusesRequest.Builder.() -> Unit): ListEventBusesResponse = listEventBuses(ListEventBusesRequest.Builder().apply(block).build())

/**
 * You can use this to see all the partner event sources that have been shared with your Amazon Web Services account. For more information about partner event sources, see [CreateEventBus](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html).
 */
public suspend inline fun CloudWatchEventsClient.listEventSources(crossinline block: ListEventSourcesRequest.Builder.() -> Unit): ListEventSourcesResponse = listEventSources(ListEventSourcesRequest.Builder().apply(block).build())

/**
 * An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular partner event source name is associated with. This operation is not used by Amazon Web Services customers.
 */
public suspend inline fun CloudWatchEventsClient.listPartnerEventSourceAccounts(crossinline block: ListPartnerEventSourceAccountsRequest.Builder.() -> Unit): ListPartnerEventSourceAccountsResponse = listPartnerEventSourceAccounts(ListPartnerEventSourceAccountsRequest.Builder().apply(block).build())

/**
 * An SaaS partner can use this operation to list all the partner event source names that they have created. This operation is not used by Amazon Web Services customers.
 */
public suspend inline fun CloudWatchEventsClient.listPartnerEventSources(crossinline block: ListPartnerEventSourcesRequest.Builder.() -> Unit): ListPartnerEventSourcesResponse = listPartnerEventSources(ListPartnerEventSourcesRequest.Builder().apply(block).build())

/**
 * Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names. Filter parameters are exclusive.
 */
public suspend inline fun CloudWatchEventsClient.listReplays(crossinline block: ListReplaysRequest.Builder.() -> Unit): ListReplaysResponse = listReplays(ListReplaysRequest.Builder().apply(block).build())

/**
 * Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a specific target in your account.
 */
public suspend inline fun CloudWatchEventsClient.listRuleNamesByTarget(crossinline block: ListRuleNamesByTargetRequest.Builder.() -> Unit): ListRuleNamesByTargetResponse = listRuleNamesByTarget(ListRuleNamesByTargetRequest.Builder().apply(block).build())

/**
 * Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to the rule names.
 *
 * ListRules does not list the targets of a rule. To see the targets associated with a rule, use [ListTargetsByRule](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html).
 */
public suspend inline fun CloudWatchEventsClient.listRules(crossinline block: ListRulesRequest.Builder.() -> Unit): ListRulesResponse = listRules(ListRulesRequest.Builder().apply(block).build())

/**
 * Displays the tags associated with an EventBridge resource. In EventBridge, rules and event buses can be tagged.
 */
public suspend inline fun CloudWatchEventsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the targets assigned to the specified rule.
 */
public suspend inline fun CloudWatchEventsClient.listTargetsByRule(crossinline block: ListTargetsByRuleRequest.Builder.() -> Unit): ListTargetsByRuleResponse = listTargetsByRule(ListTargetsByRuleRequest.Builder().apply(block).build())

/**
 * Sends custom events to Amazon EventBridge so that they can be matched to rules.
 */
public suspend inline fun CloudWatchEventsClient.putEvents(crossinline block: PutEventsRequest.Builder.() -> Unit): PutEventsResponse = putEvents(PutEventsRequest.Builder().apply(block).build())

/**
 * This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services customers do not use this operation.
 */
public suspend inline fun CloudWatchEventsClient.putPartnerEvents(crossinline block: PutPartnerEventsRequest.Builder.() -> Unit): PutPartnerEventsResponse = putPartnerEvents(PutPartnerEventsRequest.Builder().apply(block).build())

/**
 * Running `PutPermission` permits the specified Amazon Web Services account or Amazon Web Services organization to put events to the specified *event bus*. Amazon EventBridge (CloudWatch Events) rules in your account are triggered by these events arriving to an event bus in your account.
 *
 * For another account to send events to your account, that external account must have an EventBridge rule with your account's event bus as a target.
 *
 * To enable multiple Amazon Web Services accounts to put events to your event bus, run `PutPermission` once for each of these accounts. Or, if all the accounts are members of the same Amazon Web Services organization, you can run `PutPermission` once specifying `Principal` as "*" and specifying the Amazon Web Services organization ID in `Condition`, to grant permissions to all accounts in that organization.
 *
 * If you grant permissions using an organization, then accounts in that organization must specify a `RoleArn` with proper permissions when they use `PutTarget` to add your account's event bus as a target. For more information, see [Sending and Receiving Events Between Amazon Web Services Accounts](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html) in the *Amazon EventBridge User Guide*.
 *
 * The permission policy on the event bus cannot exceed 10 KB in size.
 */
public suspend inline fun CloudWatchEventsClient.putPermission(crossinline block: PutPermissionRequest.Builder.() -> Unit): PutPermissionResponse = putPermission(PutPermissionRequest.Builder().apply(block).build())

/**
 * Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can disable a rule using [DisableRule](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html).
 *
 * A single rule watches for events from a single event bus. Events generated by Amazon Web Services services go to your account's default event bus. Events generated by SaaS partner services or applications go to the matching partner event bus. If you have custom applications or services, you can specify whether their events go to your default event bus or a custom event bus that you have created. For more information, see [CreateEventBus](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html).
 *
 * If you are updating an existing rule, the rule is replaced with what you specify in this `PutRule` command. If you omit arguments in `PutRule`, the old values for those arguments are not kept. Instead, they are replaced with null values.
 *
 * When you create or update a rule, incoming events might not immediately start matching to new or updated rules. Allow a short period of time for changes to take effect.
 *
 * A rule must contain at least an EventPattern or ScheduleExpression. Rules with EventPatterns are triggered when a matching event is observed. Rules with ScheduleExpressions self-trigger based on the given schedule. A rule can have both an EventPattern and a ScheduleExpression, in which case the rule triggers on matching events as well as on a schedule.
 *
 * When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only rules with certain tag values. To use the `PutRule` operation and assign tags, you must have both the `events:PutRule` and `events:TagResource` permissions.
 *
 * If you are updating an existing rule, any tags you specify in the `PutRule` operation are ignored. To update the tags of an existing rule, use [TagResource](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html) and [UntagResource](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html).
 *
 * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.
 *
 * In EventBridge, it is possible to create rules that lead to infinite loops, where a rule is fired repeatedly. For example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the desired state. If the rule is not written carefully, the subsequent change to the ACLs fires the rule again, creating an infinite loop.
 *
 * To prevent this, write the rules so that the triggered actions do not re-fire the same rule. For example, your rule could fire only if ACLs are found to be in a bad state, instead of after any change.
 *
 * An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which alerts you when charges exceed your specified limit. For more information, see [Managing Your Costs with Budgets](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html).
 */
public suspend inline fun CloudWatchEventsClient.putRule(crossinline block: PutRuleRequest.Builder.() -> Unit): PutRuleResponse = putRule(PutRuleRequest.Builder().apply(block).build())

/**
 * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
 *
 * Targets are the resources that are invoked when a rule is triggered.
 *
 * You can configure the following as targets for Events:
 * + [API destination](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html)
 * + Amazon API Gateway REST API endpoints
 * + API Gateway
 * + Batch job queue
 * + CloudWatch Logs group
 * + CodeBuild project
 * + CodePipeline
 * + Amazon EC2 `CreateSnapshot` API call
 * + Amazon EC2 `RebootInstances` API call
 * + Amazon EC2 `StopInstances` API call
 * + Amazon EC2 `TerminateInstances` API call
 * + Amazon ECS tasks
 * + Event bus in a different Amazon Web Services account or Region.You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon) us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.
 * + Firehose delivery stream (Kinesis Data Firehose)
 * + Inspector assessment template (Amazon Inspector)
 * + Kinesis stream (Kinesis Data Stream)
 * + Lambda function
 * + Redshift clusters (Data API statement execution)
 * + Amazon SNS topic
 * + Amazon SQS queues (includes FIFO queues
 * + SSM Automation
 * + SSM OpsItem
 * + SSM Run Command
 * + Step Functions state machines
 *
 * Creating rules with built-in targets is supported only in the Amazon Web Services Management Console. The built-in targets are `EC2 CreateSnapshot API call`, `EC2 RebootInstances API call`, `EC2 StopInstances API call`, and `EC2 TerminateInstances API call`.
 *
 * For some target types, `PutTargets` provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the `KinesisParameters` argument. To invoke a command on multiple EC2 instances with one rule, you can use the `RunCommandParameters` field.
 *
 * To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions. For Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams, Step Functions state machines and API Gateway REST APIs, EventBridge relies on IAM roles that you specify in the `RoleARN` argument in `PutTargets`. For more information, see [Authentication and Access Control](https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html) in the *Amazon EventBridge User Guide*.
 *
 * If another Amazon Web Services account is in the same region and has granted you permission (using `PutPermission`), you can send events to that account. Set that account's event bus as a target of the rules in your account. To send the matched events to the other account, specify that account's event bus as the `Arn` value when you run `PutTargets`. If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see [Amazon EventBridge Pricing](http://aws.amazon.com/eventbridge/pricing/).
 *
 * `Input`, `InputPath`, and `InputTransformer` are not available with `PutTarget` if the target is an event bus of a different Amazon Web Services account.
 *
 * If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a `RoleArn` with proper permissions in the `Target` structure. For more information, see [Sending and Receiving Events Between Amazon Web Services Accounts](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html) in the *Amazon EventBridge User Guide*.
 *
 * For more information about enabling cross-account events, see [PutPermission](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html).
 *
 * **Input**, **InputPath**, and **InputTransformer** are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:
 * + If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).
 * + If **Input** is specified in the form of valid JSON, then the matched event is overridden with this constant.
 * + If **InputPath** is specified in the form of JSONPath (for example, `$.detail`), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).
 * + If **InputTransformer** is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.
 *
 * When you specify `InputPath` or `InputTransformer`, you must use JSON dot notation, not bracket notation.
 *
 * When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.
 *
 * This action can partially fail if too many requests are made at the same time. If that happens, `FailedEntryCount` is non-zero in the response and each entry in `FailedEntries` provides the ID of the failed target and the error code.
 */
public suspend inline fun CloudWatchEventsClient.putTargets(crossinline block: PutTargetsRequest.Builder.() -> Unit): PutTargetsResponse = putTargets(PutTargetsRequest.Builder().apply(block).build())

/**
 * Revokes the permission of another Amazon Web Services account to be able to put events to the specified event bus. Specify the account to revoke by the `StatementId` value that you associated with the account when you granted it permission with `PutPermission`. You can find the `StatementId` by using [DescribeEventBus](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html).
 */
public suspend inline fun CloudWatchEventsClient.removePermission(crossinline block: RemovePermissionRequest.Builder.() -> Unit): RemovePermissionResponse = removePermission(RemovePermissionRequest.Builder().apply(block).build())

/**
 * Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be invoked.
 *
 * When you remove a target, when the associated rule triggers, removed targets might continue to be invoked. Allow a short period of time for changes to take effect.
 *
 * This action can partially fail if too many requests are made at the same time. If that happens, `FailedEntryCount` is non-zero in the response and each entry in `FailedEntries` provides the ID of the failed target and the error code.
 */
public suspend inline fun CloudWatchEventsClient.removeTargets(crossinline block: RemoveTargetsRequest.Builder.() -> Unit): RemoveTargetsResponse = removeTargets(RemoveTargetsRequest.Builder().apply(block).build())

/**
 * Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you specify an `EventStartTime` and an `EventEndTime` that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use `DescribeReplay` to determine the progress of a replay. The value returned for `EventLastReplayedTime` indicates the time within the specified time range associated with the last event replayed.
 */
public suspend inline fun CloudWatchEventsClient.startReplay(crossinline block: StartReplayRequest.Builder.() -> Unit): StartReplayResponse = startReplay(StartReplayRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In EventBridge, rules and event buses can be tagged.
 *
 * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
 *
 * You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate as many as 50 tags with a resource.
 */
public suspend inline fun CloudWatchEventsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Tests whether the specified event pattern matches the provided event.
 *
 * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.
 */
public suspend inline fun CloudWatchEventsClient.testEventPattern(crossinline block: TestEventPatternRequest.Builder.() -> Unit): TestEventPatternResponse = testEventPattern(TestEventPatternRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge (CloudWatch Events), rules and event buses can be tagged.
 */
public suspend inline fun CloudWatchEventsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an API destination.
 */
public suspend inline fun CloudWatchEventsClient.updateApiDestination(crossinline block: UpdateApiDestinationRequest.Builder.() -> Unit): UpdateApiDestinationResponse = updateApiDestination(UpdateApiDestinationRequest.Builder().apply(block).build())

/**
 * Updates the specified archive.
 */
public suspend inline fun CloudWatchEventsClient.updateArchive(crossinline block: UpdateArchiveRequest.Builder.() -> Unit): UpdateArchiveResponse = updateArchive(UpdateArchiveRequest.Builder().apply(block).build())

/**
 * Updates settings for a connection.
 */
public suspend inline fun CloudWatchEventsClient.updateConnection(crossinline block: UpdateConnectionRequest.Builder.() -> Unit): UpdateConnectionResponse = updateConnection(UpdateConnectionRequest.Builder().apply(block).build())
