// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.serde

import aws.sdk.kotlin.services.cloudwatchevents.model.CloudWatchEventsException
import aws.sdk.kotlin.services.cloudwatchevents.model.ListPartnerEventSourceAccountsResponse
import aws.sdk.kotlin.services.cloudwatchevents.model.PartnerEventSourceAccount
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListPartnerEventSourceAccountsOperationDeserializer: HttpDeserialize<ListPartnerEventSourceAccountsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListPartnerEventSourceAccountsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListPartnerEventSourceAccountsError(context, call)
        }
        val builder = ListPartnerEventSourceAccountsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListPartnerEventSourceAccountsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListPartnerEventSourceAccountsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudWatchEventsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationDisabledException" -> OperationDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudWatchEventsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListPartnerEventSourceAccountsOperationBody(builder: ListPartnerEventSourceAccountsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val PARTNEREVENTSOURCEACCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PartnerEventSourceAccounts"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(PARTNEREVENTSOURCEACCOUNTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PARTNEREVENTSOURCEACCOUNTS_DESCRIPTOR.index -> builder.partnerEventSourceAccounts =
                    deserializer.deserializeList(PARTNEREVENTSOURCEACCOUNTS_DESCRIPTOR) {
                        val col0 = mutableListOf<PartnerEventSourceAccount>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePartnerEventSourceAccountDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
