// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model



/**
 * Targets are the resources to be invoked when a rule is triggered. For a complete list of services and resources that can be set as a target, see [PutTargets](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutTargets.html).
 *
 * If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a `RoleArn` with proper permissions in the `Target` structure. For more information, see [Sending and Receiving Events Between Amazon Web Services Accounts](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html) in the *Amazon EventBridge User Guide*.
 */
public class Target private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * If the event target is an Batch job, this contains the job definition, job name, and other parameters. For more information, see [Jobs](https://docs.aws.amazon.com/batch/latest/userguide/jobs.html) in the *Batch User Guide*.
     */
    public val batchParameters: aws.sdk.kotlin.services.cloudwatchevents.model.BatchParameters? = builder.batchParameters
    /**
     * The `DeadLetterConfig` that defines the target queue to send dead-letter queue events to.
     */
    public val deadLetterConfig: aws.sdk.kotlin.services.cloudwatchevents.model.DeadLetterConfig? = builder.deadLetterConfig
    /**
     * Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For more information about Amazon ECS tasks, see [Task Definitions ](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon EC2 Container Service Developer Guide*.
     */
    public val ecsParameters: aws.sdk.kotlin.services.cloudwatchevents.model.EcsParameters? = builder.ecsParameters
    /**
     * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.
     *
     * If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
     */
    public val httpParameters: aws.sdk.kotlin.services.cloudwatchevents.model.HttpParameters? = builder.httpParameters
    /**
     * The ID of the target. We recommend using a memorable and unique string.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](http://www.rfc-editor.org/rfc/rfc7159.txt).
     */
    public val input: kotlin.String? = builder.input
    /**
     * The value of the JSONPath that is used for extracting part of the matched event when passing it to the target. You must use JSON dot notation, not bracket notation. For more information about JSON paths, see [JSONPath](http://goessner.net/articles/JsonPath/).
     */
    public val inputPath: kotlin.String? = builder.inputPath
    /**
     * Settings to enable you to provide custom input to a target based on certain event data. You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
     */
    public val inputTransformer: aws.sdk.kotlin.services.cloudwatchevents.model.InputTransformer? = builder.inputTransformer
    /**
     * The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream. If you do not include this parameter, the default is to use the `eventId` as the partition key.
     */
    public val kinesisParameters: aws.sdk.kotlin.services.cloudwatchevents.model.KinesisParameters? = builder.kinesisParameters
    /**
     * Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.
     *
     * If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
     */
    public val redshiftDataParameters: aws.sdk.kotlin.services.cloudwatchevents.model.RedshiftDataParameters? = builder.redshiftDataParameters
    /**
     * The `RetryPolicy` object that contains the retry policy configuration to use for the dead-letter queue.
     */
    public val retryPolicy: aws.sdk.kotlin.services.cloudwatchevents.model.RetryPolicy? = builder.retryPolicy
    /**
     * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule triggers multiple targets, you can use a different IAM role for each target.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
     */
    public val runCommandParameters: aws.sdk.kotlin.services.cloudwatchevents.model.RunCommandParameters? = builder.runCommandParameters
    /**
     * Contains the SageMaker Model Building Pipeline parameters to start execution of a SageMaker Model Building Pipeline.
     *
     * If you specify a SageMaker Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
     */
    public val sageMakerPipelineParameters: aws.sdk.kotlin.services.cloudwatchevents.model.SageMakerPipelineParameters? = builder.sageMakerPipelineParameters
    /**
     * Contains the message group ID to use when the target is a FIFO queue.
     *
     * If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
     */
    public val sqsParameters: aws.sdk.kotlin.services.cloudwatchevents.model.SqsParameters? = builder.sqsParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.Target = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Target(")
        append("arn=$arn,")
        append("batchParameters=$batchParameters,")
        append("deadLetterConfig=$deadLetterConfig,")
        append("ecsParameters=$ecsParameters,")
        append("httpParameters=$httpParameters,")
        append("id=$id,")
        append("input=$input,")
        append("inputPath=$inputPath,")
        append("inputTransformer=$inputTransformer,")
        append("kinesisParameters=$kinesisParameters,")
        append("redshiftDataParameters=$redshiftDataParameters,")
        append("retryPolicy=$retryPolicy,")
        append("roleArn=$roleArn,")
        append("runCommandParameters=$runCommandParameters,")
        append("sageMakerPipelineParameters=$sageMakerPipelineParameters,")
        append("sqsParameters=$sqsParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (batchParameters?.hashCode() ?: 0)
        result = 31 * result + (deadLetterConfig?.hashCode() ?: 0)
        result = 31 * result + (ecsParameters?.hashCode() ?: 0)
        result = 31 * result + (httpParameters?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (inputPath?.hashCode() ?: 0)
        result = 31 * result + (inputTransformer?.hashCode() ?: 0)
        result = 31 * result + (kinesisParameters?.hashCode() ?: 0)
        result = 31 * result + (redshiftDataParameters?.hashCode() ?: 0)
        result = 31 * result + (retryPolicy?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (runCommandParameters?.hashCode() ?: 0)
        result = 31 * result + (sageMakerPipelineParameters?.hashCode() ?: 0)
        result = 31 * result + (sqsParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Target

        if (arn != other.arn) return false
        if (batchParameters != other.batchParameters) return false
        if (deadLetterConfig != other.deadLetterConfig) return false
        if (ecsParameters != other.ecsParameters) return false
        if (httpParameters != other.httpParameters) return false
        if (id != other.id) return false
        if (input != other.input) return false
        if (inputPath != other.inputPath) return false
        if (inputTransformer != other.inputTransformer) return false
        if (kinesisParameters != other.kinesisParameters) return false
        if (redshiftDataParameters != other.redshiftDataParameters) return false
        if (retryPolicy != other.retryPolicy) return false
        if (roleArn != other.roleArn) return false
        if (runCommandParameters != other.runCommandParameters) return false
        if (sageMakerPipelineParameters != other.sageMakerPipelineParameters) return false
        if (sqsParameters != other.sqsParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.Target = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        public var arn: kotlin.String? = null
        /**
         * If the event target is an Batch job, this contains the job definition, job name, and other parameters. For more information, see [Jobs](https://docs.aws.amazon.com/batch/latest/userguide/jobs.html) in the *Batch User Guide*.
         */
        public var batchParameters: aws.sdk.kotlin.services.cloudwatchevents.model.BatchParameters? = null
        /**
         * The `DeadLetterConfig` that defines the target queue to send dead-letter queue events to.
         */
        public var deadLetterConfig: aws.sdk.kotlin.services.cloudwatchevents.model.DeadLetterConfig? = null
        /**
         * Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For more information about Amazon ECS tasks, see [Task Definitions ](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon EC2 Container Service Developer Guide*.
         */
        public var ecsParameters: aws.sdk.kotlin.services.cloudwatchevents.model.EcsParameters? = null
        /**
         * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.
         *
         * If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
         */
        public var httpParameters: aws.sdk.kotlin.services.cloudwatchevents.model.HttpParameters? = null
        /**
         * The ID of the target. We recommend using a memorable and unique string.
         */
        public var id: kotlin.String? = null
        /**
         * Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](http://www.rfc-editor.org/rfc/rfc7159.txt).
         */
        public var input: kotlin.String? = null
        /**
         * The value of the JSONPath that is used for extracting part of the matched event when passing it to the target. You must use JSON dot notation, not bracket notation. For more information about JSON paths, see [JSONPath](http://goessner.net/articles/JsonPath/).
         */
        public var inputPath: kotlin.String? = null
        /**
         * Settings to enable you to provide custom input to a target based on certain event data. You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
         */
        public var inputTransformer: aws.sdk.kotlin.services.cloudwatchevents.model.InputTransformer? = null
        /**
         * The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream. If you do not include this parameter, the default is to use the `eventId` as the partition key.
         */
        public var kinesisParameters: aws.sdk.kotlin.services.cloudwatchevents.model.KinesisParameters? = null
        /**
         * Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.
         *
         * If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
         */
        public var redshiftDataParameters: aws.sdk.kotlin.services.cloudwatchevents.model.RedshiftDataParameters? = null
        /**
         * The `RetryPolicy` object that contains the retry policy configuration to use for the dead-letter queue.
         */
        public var retryPolicy: aws.sdk.kotlin.services.cloudwatchevents.model.RetryPolicy? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule triggers multiple targets, you can use a different IAM role for each target.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
         */
        public var runCommandParameters: aws.sdk.kotlin.services.cloudwatchevents.model.RunCommandParameters? = null
        /**
         * Contains the SageMaker Model Building Pipeline parameters to start execution of a SageMaker Model Building Pipeline.
         *
         * If you specify a SageMaker Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
         */
        public var sageMakerPipelineParameters: aws.sdk.kotlin.services.cloudwatchevents.model.SageMakerPipelineParameters? = null
        /**
         * Contains the message group ID to use when the target is a FIFO queue.
         *
         * If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
         */
        public var sqsParameters: aws.sdk.kotlin.services.cloudwatchevents.model.SqsParameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.Target) : this() {
            this.arn = x.arn
            this.batchParameters = x.batchParameters
            this.deadLetterConfig = x.deadLetterConfig
            this.ecsParameters = x.ecsParameters
            this.httpParameters = x.httpParameters
            this.id = x.id
            this.input = x.input
            this.inputPath = x.inputPath
            this.inputTransformer = x.inputTransformer
            this.kinesisParameters = x.kinesisParameters
            this.redshiftDataParameters = x.redshiftDataParameters
            this.retryPolicy = x.retryPolicy
            this.roleArn = x.roleArn
            this.runCommandParameters = x.runCommandParameters
            this.sageMakerPipelineParameters = x.sageMakerPipelineParameters
            this.sqsParameters = x.sqsParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.Target = Target(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.BatchParameters] inside the given [block]
         */
        public fun batchParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.BatchParameters.Builder.() -> kotlin.Unit) {
            this.batchParameters = aws.sdk.kotlin.services.cloudwatchevents.model.BatchParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.DeadLetterConfig] inside the given [block]
         */
        public fun deadLetterConfig(block: aws.sdk.kotlin.services.cloudwatchevents.model.DeadLetterConfig.Builder.() -> kotlin.Unit) {
            this.deadLetterConfig = aws.sdk.kotlin.services.cloudwatchevents.model.DeadLetterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.EcsParameters] inside the given [block]
         */
        public fun ecsParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.EcsParameters.Builder.() -> kotlin.Unit) {
            this.ecsParameters = aws.sdk.kotlin.services.cloudwatchevents.model.EcsParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.HttpParameters] inside the given [block]
         */
        public fun httpParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.HttpParameters.Builder.() -> kotlin.Unit) {
            this.httpParameters = aws.sdk.kotlin.services.cloudwatchevents.model.HttpParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.InputTransformer] inside the given [block]
         */
        public fun inputTransformer(block: aws.sdk.kotlin.services.cloudwatchevents.model.InputTransformer.Builder.() -> kotlin.Unit) {
            this.inputTransformer = aws.sdk.kotlin.services.cloudwatchevents.model.InputTransformer.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.KinesisParameters] inside the given [block]
         */
        public fun kinesisParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.KinesisParameters.Builder.() -> kotlin.Unit) {
            this.kinesisParameters = aws.sdk.kotlin.services.cloudwatchevents.model.KinesisParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.RedshiftDataParameters] inside the given [block]
         */
        public fun redshiftDataParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.RedshiftDataParameters.Builder.() -> kotlin.Unit) {
            this.redshiftDataParameters = aws.sdk.kotlin.services.cloudwatchevents.model.RedshiftDataParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.RetryPolicy] inside the given [block]
         */
        public fun retryPolicy(block: aws.sdk.kotlin.services.cloudwatchevents.model.RetryPolicy.Builder.() -> kotlin.Unit) {
            this.retryPolicy = aws.sdk.kotlin.services.cloudwatchevents.model.RetryPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.RunCommandParameters] inside the given [block]
         */
        public fun runCommandParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.RunCommandParameters.Builder.() -> kotlin.Unit) {
            this.runCommandParameters = aws.sdk.kotlin.services.cloudwatchevents.model.RunCommandParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.SageMakerPipelineParameters] inside the given [block]
         */
        public fun sageMakerPipelineParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.SageMakerPipelineParameters.Builder.() -> kotlin.Unit) {
            this.sageMakerPipelineParameters = aws.sdk.kotlin.services.cloudwatchevents.model.SageMakerPipelineParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.SqsParameters] inside the given [block]
         */
        public fun sqsParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.SqsParameters.Builder.() -> kotlin.Unit) {
            this.sqsParameters = aws.sdk.kotlin.services.cloudwatchevents.model.SqsParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            return this
        }
    }
}
