// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model



/**
 * Contains information about a rule in Amazon EventBridge.
 */
public class Rule private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the rule.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The description of the rule.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.
     */
    public val eventBusName: kotlin.String? = builder.eventBusName
    /**
     * The event pattern of the rule. For more information, see [Events and Event Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html) in the *Amazon EventBridge User Guide*.
     */
    public val eventPattern: kotlin.String? = builder.eventPattern
    /**
     * If the rule was created on behalf of your account by an Amazon Web Services service, this field displays the principal name of the service that created the rule.
     */
    public val managedBy: kotlin.String? = builder.managedBy
    /**
     * The name of the rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the role that is used for target invocation.
     *
     * If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a `RoleArn` with proper permissions in the `Target` structure, instead of here in this parameter.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see [Creating an Amazon EventBridge rule that runs on a schedule](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html).
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * The state of the rule.
     */
    public val state: aws.sdk.kotlin.services.cloudwatchevents.model.RuleState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.Rule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Rule(")
        append("arn=$arn,")
        append("description=$description,")
        append("eventBusName=$eventBusName,")
        append("eventPattern=$eventPattern,")
        append("managedBy=$managedBy,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("scheduleExpression=$scheduleExpression,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventBusName?.hashCode() ?: 0)
        result = 31 * result + (eventPattern?.hashCode() ?: 0)
        result = 31 * result + (managedBy?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Rule

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (eventBusName != other.eventBusName) return false
        if (eventPattern != other.eventPattern) return false
        if (managedBy != other.managedBy) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.Rule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the rule.
         */
        public var arn: kotlin.String? = null
        /**
         * The description of the rule.
         */
        public var description: kotlin.String? = null
        /**
         * The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.
         */
        public var eventBusName: kotlin.String? = null
        /**
         * The event pattern of the rule. For more information, see [Events and Event Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html) in the *Amazon EventBridge User Guide*.
         */
        public var eventPattern: kotlin.String? = null
        /**
         * If the rule was created on behalf of your account by an Amazon Web Services service, this field displays the principal name of the service that created the rule.
         */
        public var managedBy: kotlin.String? = null
        /**
         * The name of the rule.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role that is used for target invocation.
         *
         * If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a `RoleArn` with proper permissions in the `Target` structure, instead of here in this parameter.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see [Creating an Amazon EventBridge rule that runs on a schedule](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html).
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * The state of the rule.
         */
        public var state: aws.sdk.kotlin.services.cloudwatchevents.model.RuleState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.Rule) : this() {
            this.arn = x.arn
            this.description = x.description
            this.eventBusName = x.eventBusName
            this.eventPattern = x.eventPattern
            this.managedBy = x.managedBy
            this.name = x.name
            this.roleArn = x.roleArn
            this.scheduleExpression = x.scheduleExpression
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.Rule = Rule(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
