// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model



/**
 * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
 */
public class RedshiftDataParameters private constructor(builder: Builder) {
    /**
     * The name of the database. Required when authenticating using temporary credentials.
     */
    public val database: kotlin.String = requireNotNull(builder.database) { "A non-null value must be provided for database" }
    /**
     * The database user name. Required when authenticating using temporary credentials.
     */
    public val dbUser: kotlin.String? = builder.dbUser
    /**
     * The name or ARN of the secret that enables access to the database. Required when authenticating using Amazon Web Services Secrets Manager.
     */
    public val secretManagerArn: kotlin.String? = builder.secretManagerArn
    /**
     * The SQL statement text to run.
     */
    public val sql: kotlin.String = requireNotNull(builder.sql) { "A non-null value must be provided for sql" }
    /**
     * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    public val statementName: kotlin.String? = builder.statementName
    /**
     * Indicates whether to send an event back to EventBridge after the SQL statement runs.
     */
    public val withEvent: kotlin.Boolean = builder.withEvent

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.RedshiftDataParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDataParameters(")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("secretManagerArn=$secretManagerArn,")
        append("sql=$sql,")
        append("statementName=$statementName,")
        append("withEvent=$withEvent")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = database.hashCode()
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (secretManagerArn?.hashCode() ?: 0)
        result = 31 * result + (sql.hashCode())
        result = 31 * result + (statementName?.hashCode() ?: 0)
        result = 31 * result + (withEvent.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDataParameters

        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (secretManagerArn != other.secretManagerArn) return false
        if (sql != other.sql) return false
        if (statementName != other.statementName) return false
        if (withEvent != other.withEvent) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.RedshiftDataParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the database. Required when authenticating using temporary credentials.
         */
        public var database: kotlin.String? = null
        /**
         * The database user name. Required when authenticating using temporary credentials.
         */
        public var dbUser: kotlin.String? = null
        /**
         * The name or ARN of the secret that enables access to the database. Required when authenticating using Amazon Web Services Secrets Manager.
         */
        public var secretManagerArn: kotlin.String? = null
        /**
         * The SQL statement text to run.
         */
        public var sql: kotlin.String? = null
        /**
         * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
         */
        public var statementName: kotlin.String? = null
        /**
         * Indicates whether to send an event back to EventBridge after the SQL statement runs.
         */
        public var withEvent: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.RedshiftDataParameters) : this() {
            this.database = x.database
            this.dbUser = x.dbUser
            this.secretManagerArn = x.secretManagerArn
            this.sql = x.sql
            this.statementName = x.statementName
            this.withEvent = x.withEvent
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.RedshiftDataParameters = RedshiftDataParameters(this)

        internal fun correctErrors(): Builder {
            if (database == null) database = ""
            if (sql == null) sql = ""
            return this
        }
    }
}
