// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model



public class PutPermissionRequest private constructor(builder: Builder) {
    /**
     * The action that you are enabling the other account to perform.
     */
    public val action: kotlin.String? = builder.action
    /**
     * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain Amazon Web Services organization. For more information about Amazon Web Services Organizations, see [What Is Amazon Web Services Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html) in the *Amazon Web Services Organizations User Guide*.
     *
     * If you specify `Condition` with an Amazon Web Services organization ID, and specify "*" as the value for `Principal`, you grant permission to all the accounts in the named organization.
     *
     * The `Condition` is a JSON string which must contain `Type`, `Key`, and `Value` fields.
     */
    public val condition: aws.sdk.kotlin.services.cloudwatchevents.model.Condition? = builder.condition
    /**
     * The name of the event bus associated with the rule. If you omit this, the default event bus is used.
     */
    public val eventBusName: kotlin.String? = builder.eventBusName
    /**
     * A JSON string that describes the permission policy statement. You can include a `Policy` parameter in the request instead of using the `StatementId`, `Action`, `Principal`, or `Condition` parameters.
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus. Specify "*" to permit any account to put events to your default event bus.
     *
     * If you specify "*" without specifying `Condition`, avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an `account` field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.
     */
    public val principal: kotlin.String? = builder.principal
    /**
     * An identifier string for the external account that you are granting permissions to. If you later want to revoke the permission for this external account, specify this `StatementId` when you run [RemovePermission](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html).
     */
    public val statementId: kotlin.String? = builder.statementId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.PutPermissionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutPermissionRequest(")
        append("action=$action,")
        append("condition=$condition,")
        append("eventBusName=$eventBusName,")
        append("policy=$policy,")
        append("principal=$principal,")
        append("statementId=$statementId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (condition?.hashCode() ?: 0)
        result = 31 * result + (eventBusName?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (statementId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutPermissionRequest

        if (action != other.action) return false
        if (condition != other.condition) return false
        if (eventBusName != other.eventBusName) return false
        if (policy != other.policy) return false
        if (principal != other.principal) return false
        if (statementId != other.statementId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.PutPermissionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action that you are enabling the other account to perform.
         */
        public var action: kotlin.String? = null
        /**
         * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain Amazon Web Services organization. For more information about Amazon Web Services Organizations, see [What Is Amazon Web Services Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html) in the *Amazon Web Services Organizations User Guide*.
         *
         * If you specify `Condition` with an Amazon Web Services organization ID, and specify "*" as the value for `Principal`, you grant permission to all the accounts in the named organization.
         *
         * The `Condition` is a JSON string which must contain `Type`, `Key`, and `Value` fields.
         */
        public var condition: aws.sdk.kotlin.services.cloudwatchevents.model.Condition? = null
        /**
         * The name of the event bus associated with the rule. If you omit this, the default event bus is used.
         */
        public var eventBusName: kotlin.String? = null
        /**
         * A JSON string that describes the permission policy statement. You can include a `Policy` parameter in the request instead of using the `StatementId`, `Action`, `Principal`, or `Condition` parameters.
         */
        public var policy: kotlin.String? = null
        /**
         * The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus. Specify "*" to permit any account to put events to your default event bus.
         *
         * If you specify "*" without specifying `Condition`, avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an `account` field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.
         */
        public var principal: kotlin.String? = null
        /**
         * An identifier string for the external account that you are granting permissions to. If you later want to revoke the permission for this external account, specify this `StatementId` when you run [RemovePermission](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html).
         */
        public var statementId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.PutPermissionRequest) : this() {
            this.action = x.action
            this.condition = x.condition
            this.eventBusName = x.eventBusName
            this.policy = x.policy
            this.principal = x.principal
            this.statementId = x.statementId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.PutPermissionRequest = PutPermissionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.Condition] inside the given [block]
         */
        public fun condition(block: aws.sdk.kotlin.services.cloudwatchevents.model.Condition.Builder.() -> kotlin.Unit) {
            this.condition = aws.sdk.kotlin.services.cloudwatchevents.model.Condition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
