// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents an event to be submitted.
 */
public class PutEventsRequestEntry private constructor(builder: Builder) {
    /**
     * A valid JSON string. There is no other schema imposed. The JSON string may contain fields and nested subobjects.
     */
    public val detail: kotlin.String? = builder.detail
    /**
     * Free-form string used to decide what fields to expect in the event detail.
     */
    public val detailType: kotlin.String? = builder.detailType
    /**
     * The name or ARN of the event bus to receive the event. Only the rules that are associated with this event bus are used to match the event. If you omit this, the default event bus is used.
     */
    public val eventBusName: kotlin.String? = builder.eventBusName
    /**
     * Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
     */
    public val resources: List<String>? = builder.resources
    /**
     * The source of the event.
     */
    public val source: kotlin.String? = builder.source
    /**
     * The time stamp of the event, per [RFC3339](https://www.rfc-editor.org/rfc/rfc3339.txt). If no time stamp is provided, the time stamp of the [PutEvents](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) call is used.
     */
    public val time: aws.smithy.kotlin.runtime.time.Instant? = builder.time
    /**
     * An X-Ray trade header, which is an http header (X-Amzn-Trace-Id) that contains the trace-id associated with the event.
     *
     * To learn more about X-Ray trace headers, see [Tracing header](https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-tracingheader) in the X-Ray Developer Guide.
     */
    public val traceHeader: kotlin.String? = builder.traceHeader

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.PutEventsRequestEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutEventsRequestEntry(")
        append("detail=$detail,")
        append("detailType=$detailType,")
        append("eventBusName=$eventBusName,")
        append("resources=$resources,")
        append("source=$source,")
        append("time=$time,")
        append("traceHeader=$traceHeader")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = detail?.hashCode() ?: 0
        result = 31 * result + (detailType?.hashCode() ?: 0)
        result = 31 * result + (eventBusName?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        result = 31 * result + (traceHeader?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutEventsRequestEntry

        if (detail != other.detail) return false
        if (detailType != other.detailType) return false
        if (eventBusName != other.eventBusName) return false
        if (resources != other.resources) return false
        if (source != other.source) return false
        if (time != other.time) return false
        if (traceHeader != other.traceHeader) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.PutEventsRequestEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A valid JSON string. There is no other schema imposed. The JSON string may contain fields and nested subobjects.
         */
        public var detail: kotlin.String? = null
        /**
         * Free-form string used to decide what fields to expect in the event detail.
         */
        public var detailType: kotlin.String? = null
        /**
         * The name or ARN of the event bus to receive the event. Only the rules that are associated with this event bus are used to match the event. If you omit this, the default event bus is used.
         */
        public var eventBusName: kotlin.String? = null
        /**
         * Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
         */
        public var resources: List<String>? = null
        /**
         * The source of the event.
         */
        public var source: kotlin.String? = null
        /**
         * The time stamp of the event, per [RFC3339](https://www.rfc-editor.org/rfc/rfc3339.txt). If no time stamp is provided, the time stamp of the [PutEvents](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) call is used.
         */
        public var time: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An X-Ray trade header, which is an http header (X-Amzn-Trace-Id) that contains the trace-id associated with the event.
         *
         * To learn more about X-Ray trace headers, see [Tracing header](https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-tracingheader) in the X-Ray Developer Guide.
         */
        public var traceHeader: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.PutEventsRequestEntry) : this() {
            this.detail = x.detail
            this.detailType = x.detailType
            this.eventBusName = x.eventBusName
            this.resources = x.resources
            this.source = x.source
            this.time = x.time
            this.traceHeader = x.traceHeader
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.PutEventsRequestEntry = PutEventsRequestEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
