// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model



/**
 * This object enables you to specify a JSON path to extract from the event and use as the partition key for the Amazon Kinesis data stream, so that you can control the shard to which the event goes. If you do not include this parameter, the default is to use the `eventId` as the partition key.
 */
public class KinesisParameters private constructor(builder: Builder) {
    /**
     * The JSON path to be extracted from the event and used as the partition key. For more information, see [Amazon Kinesis Streams Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key) in the *Amazon Kinesis Streams Developer Guide*.
     */
    public val partitionKeyPath: kotlin.String = requireNotNull(builder.partitionKeyPath) { "A non-null value must be provided for partitionKeyPath" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.KinesisParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisParameters(")
        append("partitionKeyPath=$partitionKeyPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = partitionKeyPath.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisParameters

        if (partitionKeyPath != other.partitionKeyPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.KinesisParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The JSON path to be extracted from the event and used as the partition key. For more information, see [Amazon Kinesis Streams Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key) in the *Amazon Kinesis Streams Developer Guide*.
         */
        public var partitionKeyPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.KinesisParameters) : this() {
            this.partitionKeyPath = x.partitionKeyPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.KinesisParameters = KinesisParameters(this)

        internal fun correctErrors(): Builder {
            if (partitionKeyPath == null) partitionKeyPath = ""
            return this
        }
    }
}
