// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchevents.model



/**
 * Contains the response parameters when OAuth is specified as the authorization type.
 */
public class ConnectionOAuthResponseParameters private constructor(builder: Builder) {
    /**
     * The URL to the HTTP endpoint that authorized the request.
     */
    public val authorizationEndpoint: kotlin.String? = builder.authorizationEndpoint
    /**
     * A `ConnectionOAuthClientResponseParameters` object that contains details about the client parameters returned when OAuth is specified as the authorization type.
     */
    public val clientParameters: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthClientResponseParameters? = builder.clientParameters
    /**
     * The method used to connect to the HTTP endpoint.
     */
    public val httpMethod: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthHttpMethod? = builder.httpMethod
    /**
     * The additional HTTP parameters used for the OAuth authorization request.
     */
    public val oAuthHttpParameters: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters? = builder.oAuthHttpParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthResponseParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectionOAuthResponseParameters(")
        append("authorizationEndpoint=$authorizationEndpoint,")
        append("clientParameters=$clientParameters,")
        append("httpMethod=$httpMethod,")
        append("oAuthHttpParameters=$oAuthHttpParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizationEndpoint?.hashCode() ?: 0
        result = 31 * result + (clientParameters?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (oAuthHttpParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectionOAuthResponseParameters

        if (authorizationEndpoint != other.authorizationEndpoint) return false
        if (clientParameters != other.clientParameters) return false
        if (httpMethod != other.httpMethod) return false
        if (oAuthHttpParameters != other.oAuthHttpParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthResponseParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The URL to the HTTP endpoint that authorized the request.
         */
        public var authorizationEndpoint: kotlin.String? = null
        /**
         * A `ConnectionOAuthClientResponseParameters` object that contains details about the client parameters returned when OAuth is specified as the authorization type.
         */
        public var clientParameters: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthClientResponseParameters? = null
        /**
         * The method used to connect to the HTTP endpoint.
         */
        public var httpMethod: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthHttpMethod? = null
        /**
         * The additional HTTP parameters used for the OAuth authorization request.
         */
        public var oAuthHttpParameters: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthResponseParameters) : this() {
            this.authorizationEndpoint = x.authorizationEndpoint
            this.clientParameters = x.clientParameters
            this.httpMethod = x.httpMethod
            this.oAuthHttpParameters = x.oAuthHttpParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthResponseParameters = ConnectionOAuthResponseParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthClientResponseParameters] inside the given [block]
         */
        public fun clientParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthClientResponseParameters.Builder.() -> kotlin.Unit) {
            this.clientParameters = aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionOAuthClientResponseParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters] inside the given [block]
         */
        public fun oAuthHttpParameters(block: aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters.Builder.() -> kotlin.Unit) {
            this.oAuthHttpParameters = aws.sdk.kotlin.services.cloudwatchevents.model.ConnectionHttpParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
