// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.waiters

import aws.sdk.kotlin.services.cloudwatch.CloudWatchClient
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsRequest
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import aws.smithy.kotlin.runtime.util.length
import kotlin.time.Duration.Companion.milliseconds


public suspend fun CloudWatchClient.waitUntilAlarmExists(request: DescribeAlarmsRequest = DescribeAlarmsRequest { }): Outcome<DescribeAlarmsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeAlarmsRequest, DescribeAlarmsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val metricAlarms = it.metricAlarms
            val metricAlarmsOrEmpty = metricAlarms?.flattenIfPossible()
            val length = metricAlarmsOrEmpty?.length ?: 0
            val number = 0.0
            val comparison = if (length == null) null else length.compareTo(number) > 0
            comparison == true
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAlarms(request) }
}

public suspend fun CloudWatchClient.waitUntilAlarmExists(block: DescribeAlarmsRequest.Builder.() -> Unit): Outcome<DescribeAlarmsResponse> =
    waitUntilAlarmExists(DescribeAlarmsRequest.Builder().apply(block).build())

public suspend fun CloudWatchClient.waitUntilCompositeAlarmExists(request: DescribeAlarmsRequest = DescribeAlarmsRequest { }): Outcome<DescribeAlarmsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeAlarmsRequest, DescribeAlarmsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val compositeAlarms = it.compositeAlarms
            val compositeAlarmsOrEmpty = compositeAlarms?.flattenIfPossible()
            val length = compositeAlarmsOrEmpty?.length ?: 0
            val number = 0.0
            val comparison = if (length == null) null else length.compareTo(number) > 0
            comparison == true
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAlarms(request) }
}

public suspend fun CloudWatchClient.waitUntilCompositeAlarmExists(block: DescribeAlarmsRequest.Builder.() -> Unit): Outcome<DescribeAlarmsResponse> =
    waitUntilCompositeAlarmExists(DescribeAlarmsRequest.Builder().apply(block).build())
