// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.serde

import aws.sdk.kotlin.services.cloudwatch.model.CloudWatchException
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricStreamResponse
import aws.sdk.kotlin.services.cloudwatch.model.MetricStreamFilter
import aws.sdk.kotlin.services.cloudwatch.model.MetricStreamOutputFormat
import aws.sdk.kotlin.services.cloudwatch.model.MetricStreamStatisticsConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetMetricStreamOperationDeserializer: HttpDeserialize<GetMetricStreamResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetMetricStreamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMetricStreamError(context, call)
        }
        val builder = GetMetricStreamResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMetricStreamOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetMetricStreamError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudWatchException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceError" -> InternalServiceFaultDeserializer().deserialize(context, wrappedCall)
        "MissingParameter" -> MissingRequiredParameterExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudWatchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMetricStreamOperationBody(builder: GetMetricStreamResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetMetricStreamResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetMetricStreamResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetMetricStream response")
    }
    // end unwrap response wrapper

    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Arn"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("CreationDate"))
    val EXCLUDEFILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ExcludeFilters"))
    val FIREHOSEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("FirehoseArn"))
    val INCLUDEFILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("IncludeFilters"))
    val INCLUDELINKEDACCOUNTSMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IncludeLinkedAccountsMetrics"))
    val LASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("LastUpdateDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Name"))
    val OUTPUTFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("OutputFormat"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("RoleArn"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("State"))
    val STATISTICSCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("StatisticsConfigurations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://monitoring.amazonaws.com/doc/2010-08-01/"))
        trait(XmlSerialName("GetMetricStreamResult"))
        field(ARN_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(EXCLUDEFILTERS_DESCRIPTOR)
        field(FIREHOSEARN_DESCRIPTOR)
        field(INCLUDEFILTERS_DESCRIPTOR)
        field(INCLUDELINKEDACCOUNTSMETRICS_DESCRIPTOR)
        field(LASTUPDATEDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OUTPUTFORMAT_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STATISTICSCONFIGURATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromIso8601(it) }
                EXCLUDEFILTERS_DESCRIPTOR.index -> builder.excludeFilters =
                    deserializer.deserializeList(EXCLUDEFILTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricStreamFilter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricStreamFilterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FIREHOSEARN_DESCRIPTOR.index -> builder.firehoseArn = deserializeString()
                INCLUDEFILTERS_DESCRIPTOR.index -> builder.includeFilters =
                    deserializer.deserializeList(INCLUDEFILTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricStreamFilter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricStreamFilterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INCLUDELINKEDACCOUNTSMETRICS_DESCRIPTOR.index -> builder.includeLinkedAccountsMetrics = deserializeBoolean()
                LASTUPDATEDATE_DESCRIPTOR.index -> builder.lastUpdateDate = deserializeString().let { Instant.fromIso8601(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OUTPUTFORMAT_DESCRIPTOR.index -> builder.outputFormat = deserializeString().let { MetricStreamOutputFormat.fromValue(it) }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString()
                STATISTICSCONFIGURATIONS_DESCRIPTOR.index -> builder.statisticsConfigurations =
                    deserializer.deserializeList(STATISTICSCONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricStreamStatisticsConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricStreamStatisticsConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
