// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.serde

import aws.sdk.kotlin.services.cloudwatch.model.Dimension
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricStatisticsRequest
import aws.sdk.kotlin.services.cloudwatch.model.StandardUnit
import aws.sdk.kotlin.services.cloudwatch.model.Statistic
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetMetricStatisticsOperationSerializer: HttpSerialize<GetMetricStatisticsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetMetricStatisticsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeGetMetricStatisticsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeGetMetricStatisticsOperationBody(context: ExecutionContext, input: GetMetricStatisticsRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val DIMENSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Dimensions"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("EndTime"))
    val EXTENDEDSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ExtendedStatistics"))
    val METRICNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MetricName"))
    val NAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Namespace"))
    val PERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Period"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("StartTime"))
    val STATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Statistics"))
    val UNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("Unit"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("GetMetricStatisticsInput"))
        trait(QueryLiteral("Action", "GetMetricStatistics"))
        trait(QueryLiteral("Version", "2010-08-01"))
        field(DIMENSIONS_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(EXTENDEDSTATISTICS_DESCRIPTOR)
        field(METRICNAME_DESCRIPTOR)
        field(NAMESPACE_DESCRIPTOR)
        field(PERIOD_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATISTICS_DESCRIPTOR)
        field(UNIT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.dimensions != null) {
            listField(DIMENSIONS_DESCRIPTOR) {
                for (el0 in input.dimensions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDimensionDocument))
                }
            }
        }
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        if (input.extendedStatistics != null) {
            listField(EXTENDEDSTATISTICS_DESCRIPTOR) {
                for (el0 in input.extendedStatistics) {
                    serializeString(el0)
                }
            }
        }
        input.metricName?.let { field(METRICNAME_DESCRIPTOR, it) }
        input.namespace?.let { field(NAMESPACE_DESCRIPTOR, it) }
        input.period?.let { field(PERIOD_DESCRIPTOR, it) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        if (input.statistics != null) {
            listField(STATISTICS_DESCRIPTOR) {
                for (el0 in input.statistics) {
                    serializeString(el0.value)
                }
            }
        }
        input.unit?.let { field(UNIT_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
