// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.serde

import aws.sdk.kotlin.services.cloudwatch.model.CloudWatchException
import aws.sdk.kotlin.services.cloudwatch.model.GetInsightRuleReportResponse
import aws.sdk.kotlin.services.cloudwatch.model.InsightRuleContributor
import aws.sdk.kotlin.services.cloudwatch.model.InsightRuleMetricDatapoint
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class GetInsightRuleReportOperationDeserializer: HttpDeserialize<GetInsightRuleReportResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetInsightRuleReportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetInsightRuleReportError(context, call)
        }
        val builder = GetInsightRuleReportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetInsightRuleReportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetInsightRuleReportError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudWatchException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "MissingParameter" -> MissingRequiredParameterExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudWatchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetInsightRuleReportOperationBody(builder: GetInsightRuleReportResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetInsightRuleReportResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetInsightRuleReportResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetInsightRuleReport response")
    }
    // end unwrap response wrapper

    val AGGREGATEVALUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, XmlSerialName("AggregateValue"))
    val AGGREGATIONSTATISTIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AggregationStatistic"))
    val APPROXIMATEUNIQUECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("ApproximateUniqueCount"))
    val CONTRIBUTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Contributors"))
    val KEYLABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("KeyLabels"))
    val METRICDATAPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("MetricDatapoints"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://monitoring.amazonaws.com/doc/2010-08-01/"))
        trait(XmlSerialName("GetInsightRuleReportResult"))
        field(AGGREGATEVALUE_DESCRIPTOR)
        field(AGGREGATIONSTATISTIC_DESCRIPTOR)
        field(APPROXIMATEUNIQUECOUNT_DESCRIPTOR)
        field(CONTRIBUTORS_DESCRIPTOR)
        field(KEYLABELS_DESCRIPTOR)
        field(METRICDATAPOINTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGGREGATEVALUE_DESCRIPTOR.index -> builder.aggregateValue = deserializeDouble()
                AGGREGATIONSTATISTIC_DESCRIPTOR.index -> builder.aggregationStatistic = deserializeString()
                APPROXIMATEUNIQUECOUNT_DESCRIPTOR.index -> builder.approximateUniqueCount = deserializeLong()
                CONTRIBUTORS_DESCRIPTOR.index -> builder.contributors =
                    deserializer.deserializeList(CONTRIBUTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<InsightRuleContributor>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInsightRuleContributorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                KEYLABELS_DESCRIPTOR.index -> builder.keyLabels =
                    deserializer.deserializeList(KEYLABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                METRICDATAPOINTS_DESCRIPTOR.index -> builder.metricDatapoints =
                    deserializer.deserializeList(METRICDATAPOINTS_DESCRIPTOR) {
                        val col0 = mutableListOf<InsightRuleMetricDatapoint>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInsightRuleMetricDatapointDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
