// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



/**
 * By default, a metric stream always sends the `MAX`, `MIN`, `SUM`, and `SAMPLECOUNT` statistics for each metric that is streamed. This structure contains information for one metric that includes additional statistics in the stream. For more information about statistics, see CloudWatch, listed in [ CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html).
 */
public class MetricStreamStatisticsConfiguration private constructor(builder: Builder) {
    /**
     * The list of additional statistics that are to be streamed for the metrics listed in the `IncludeMetrics` array in this structure. This list can include as many as 20 statistics.
     *
     * If the `OutputFormat` for the stream is `opentelemetry1.0` or `opentelemetry0.7`, the only valid values are `p<i>??</i> ` percentile statistics such as `p90`, `p99` and so on.
     *
     * If the `OutputFormat` for the stream is `json`, the valid values include the abbreviations for all of the statistics listed in [ CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). For example, this includes `tm98, ``wm90`, `PR(:300)`, and so on.
     */
    public val additionalStatistics: List<String>? = builder.additionalStatistics
    /**
     * An array of metric name and namespace pairs that stream the additional statistics listed in the value of the `AdditionalStatistics` parameter. There can be as many as 100 pairs in the array.
     *
     * All metrics that match the combination of metric name and namespace will be streamed with the additional statistics, no matter their dimensions.
     */
    public val includeMetrics: List<MetricStreamStatisticsMetric>? = builder.includeMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.MetricStreamStatisticsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricStreamStatisticsConfiguration(")
        append("additionalStatistics=$additionalStatistics,")
        append("includeMetrics=$includeMetrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalStatistics?.hashCode() ?: 0
        result = 31 * result + (includeMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricStreamStatisticsConfiguration

        if (additionalStatistics != other.additionalStatistics) return false
        if (includeMetrics != other.includeMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.MetricStreamStatisticsConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of additional statistics that are to be streamed for the metrics listed in the `IncludeMetrics` array in this structure. This list can include as many as 20 statistics.
         *
         * If the `OutputFormat` for the stream is `opentelemetry1.0` or `opentelemetry0.7`, the only valid values are `p<i>??</i> ` percentile statistics such as `p90`, `p99` and so on.
         *
         * If the `OutputFormat` for the stream is `json`, the valid values include the abbreviations for all of the statistics listed in [ CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). For example, this includes `tm98, ``wm90`, `PR(:300)`, and so on.
         */
        public var additionalStatistics: List<String>? = null
        /**
         * An array of metric name and namespace pairs that stream the additional statistics listed in the value of the `AdditionalStatistics` parameter. There can be as many as 100 pairs in the array.
         *
         * All metrics that match the combination of metric name and namespace will be streamed with the additional statistics, no matter their dimensions.
         */
        public var includeMetrics: List<MetricStreamStatisticsMetric>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.MetricStreamStatisticsConfiguration) : this() {
            this.additionalStatistics = x.additionalStatistics
            this.includeMetrics = x.includeMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.MetricStreamStatisticsConfiguration = MetricStreamStatisticsConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
