// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



/**
 * This structure contains a metric namespace and optionally, a list of metric names, to either include in a metric stream or exclude from a metric stream.
 *
 * A metric stream's filters can include up to 1000 total names. This limit applies to the sum of namespace names and metric names in the filters. For example, this could include 10 metric namespace filters with 99 metrics each, or 20 namespace filters with 49 metrics specified in each filter.
 */
public class MetricStreamFilter private constructor(builder: Builder) {
    /**
     * The names of the metrics to either include or exclude from the metric stream.
     *
     * If you omit this parameter, all metrics in the namespace are included or excluded, depending on whether this filter is specified as an exclude filter or an include filter.
     *
     * Each metric name can contain only ASCII printable characters (ASCII range 32 through 126). Each metric name must contain at least one non-whitespace character.
     */
    public val metricNames: List<String>? = builder.metricNames
    /**
     * The name of the metric namespace for this filter.
     *
     * The namespace can contain only ASCII printable characters (ASCII range 32 through 126). It must contain at least one non-whitespace character.
     */
    public val namespace: kotlin.String? = builder.namespace

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.MetricStreamFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricStreamFilter(")
        append("metricNames=$metricNames,")
        append("namespace=$namespace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricNames?.hashCode() ?: 0
        result = 31 * result + (namespace?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricStreamFilter

        if (metricNames != other.metricNames) return false
        if (namespace != other.namespace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.MetricStreamFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The names of the metrics to either include or exclude from the metric stream.
         *
         * If you omit this parameter, all metrics in the namespace are included or excluded, depending on whether this filter is specified as an exclude filter or an include filter.
         *
         * Each metric name can contain only ASCII printable characters (ASCII range 32 through 126). Each metric name must contain at least one non-whitespace character.
         */
        public var metricNames: List<String>? = null
        /**
         * The name of the metric namespace for this filter.
         *
         * The namespace can contain only ASCII printable characters (ASCII range 32 through 126). It must contain at least one non-whitespace character.
         */
        public var namespace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.MetricStreamFilter) : this() {
            this.metricNames = x.metricNames
            this.namespace = x.namespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.MetricStreamFilter = MetricStreamFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
