// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



/**
 * This structure defines the metric to be returned, along with the statistics, period, and units.
 */
public class MetricStat private constructor(builder: Builder) {
    /**
     * The metric to return, including the metric name, namespace, and dimensions.
     */
    public val metric: aws.sdk.kotlin.services.cloudwatch.model.Metric? = builder.metric
    /**
     * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a `PutMetricData` call that includes a `StorageResolution` of 1 second.
     *
     * If the `StartTime` parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:
     * + Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
     * + Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
     * + Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
     */
    public val period: kotlin.Int? = builder.period
    /**
     * The statistic to return. It can include any CloudWatch statistic or extended statistic.
     */
    public val stat: kotlin.String? = builder.stat
    /**
     * When you are using a `Put` operation, this defines what unit you want to use when storing the metric.
     *
     * In a `Get` operation, if you omit `Unit` then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
     */
    public val unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.MetricStat = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricStat(")
        append("metric=$metric,")
        append("period=$period,")
        append("stat=$stat,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metric?.hashCode() ?: 0
        result = 31 * result + (period ?: 0)
        result = 31 * result + (stat?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricStat

        if (metric != other.metric) return false
        if (period != other.period) return false
        if (stat != other.stat) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.MetricStat = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The metric to return, including the metric name, namespace, and dimensions.
         */
        public var metric: aws.sdk.kotlin.services.cloudwatch.model.Metric? = null
        /**
         * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a `PutMetricData` call that includes a `StorageResolution` of 1 second.
         *
         * If the `StartTime` parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:
         * + Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
         * + Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
         * + Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
         */
        public var period: kotlin.Int? = null
        /**
         * The statistic to return. It can include any CloudWatch statistic or extended statistic.
         */
        public var stat: kotlin.String? = null
        /**
         * When you are using a `Put` operation, this defines what unit you want to use when storing the metric.
         *
         * In a `Get` operation, if you omit `Unit` then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
         */
        public var unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.MetricStat) : this() {
            this.metric = x.metric
            this.period = x.period
            this.stat = x.stat
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.MetricStat = MetricStat(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudwatch.model.Metric] inside the given [block]
         */
        public fun metric(block: aws.sdk.kotlin.services.cloudwatch.model.Metric.Builder.() -> kotlin.Unit) {
            this.metric = aws.sdk.kotlin.services.cloudwatch.model.Metric.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
