// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details about a metric alarm.
 */
public class MetricAlarm private constructor(builder: Builder) {
    /**
     * Indicates whether actions should be executed during any changes to the alarm state.
     */
    public val actionsEnabled: kotlin.Boolean? = builder.actionsEnabled
    /**
     * The actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public val alarmActions: List<String>? = builder.alarmActions
    /**
     * The Amazon Resource Name (ARN) of the alarm.
     */
    public val alarmArn: kotlin.String? = builder.alarmArn
    /**
     * The time stamp of the last update to the alarm configuration.
     */
    public val alarmConfigurationUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.alarmConfigurationUpdatedTimestamp
    /**
     * The description of the alarm.
     */
    public val alarmDescription: kotlin.String? = builder.alarmDescription
    /**
     * The name of the alarm.
     */
    public val alarmName: kotlin.String? = builder.alarmName
    /**
     * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.
     */
    public val comparisonOperator: aws.sdk.kotlin.services.cloudwatch.model.ComparisonOperator? = builder.comparisonOperator
    /**
     * The number of data points that must be breaching to trigger the alarm.
     */
    public val datapointsToAlarm: kotlin.Int? = builder.datapointsToAlarm
    /**
     * The dimensions for the metric associated with the alarm.
     */
    public val dimensions: List<Dimension>? = builder.dimensions
    /**
     * Used only for alarms based on percentiles. If `ignore`, the alarm state does not change during periods with too few data points to be statistically significant. If `evaluate` or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available.
     */
    public val evaluateLowSampleCountPercentile: kotlin.String? = builder.evaluateLowSampleCountPercentile
    /**
     * The number of periods over which data is compared to the specified threshold.
     */
    public val evaluationPeriods: kotlin.Int? = builder.evaluationPeriods
    /**
     * If the value of this field is `PARTIAL_DATA`, the alarm is being evaluated based on only partial data. This happens if the query used for the alarm returns more than 10,000 metrics. For more information, see [Create alarms on Metrics Insights queries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Metrics_Insights_Alarm.html).
     */
    public val evaluationState: aws.sdk.kotlin.services.cloudwatch.model.EvaluationState? = builder.evaluationState
    /**
     * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
     */
    public val extendedStatistic: kotlin.String? = builder.extendedStatistic
    /**
     * The actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public val insufficientDataActions: List<String>? = builder.insufficientDataActions
    /**
     * The name of the metric associated with the alarm, if this is an alarm based on a single metric.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each structure either retrieves a metric or performs a math expression. One item in the Metrics array is the math expression that the alarm watches. This expression by designated by having `ReturnData` set to true.
     */
    public val metrics: List<MetricDataQuery>? = builder.metrics
    /**
     * The namespace of the metric associated with the alarm.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The actions to execute when this alarm transitions to the `OK` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public val okActions: List<String>? = builder.okActions
    /**
     * The period, in seconds, over which the statistic is applied.
     */
    public val period: kotlin.Int? = builder.period
    /**
     * An explanation for the alarm state, in text format.
     */
    public val stateReason: kotlin.String? = builder.stateReason
    /**
     * An explanation for the alarm state, in JSON format.
     */
    public val stateReasonData: kotlin.String? = builder.stateReasonData
    /**
     * The date and time that the alarm's `StateValue` most recently changed.
     */
    public val stateTransitionedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.stateTransitionedTimestamp
    /**
     * The time stamp of the last update to the value of either the `StateValue` or `EvaluationState` parameters.
     */
    public val stateUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.stateUpdatedTimestamp
    /**
     * The state value for the alarm.
     */
    public val stateValue: aws.sdk.kotlin.services.cloudwatch.model.StateValue? = builder.stateValue
    /**
     * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use `ExtendedStatistic`.
     */
    public val statistic: aws.sdk.kotlin.services.cloudwatch.model.Statistic? = builder.statistic
    /**
     * The value to compare with the specified statistic.
     */
    public val threshold: kotlin.Double? = builder.threshold
    /**
     * In an alarm based on an anomaly detection model, this is the ID of the `ANOMALY_DETECTION_BAND` function used as the threshold for the alarm.
     */
    public val thresholdMetricId: kotlin.String? = builder.thresholdMetricId
    /**
     * Sets how this alarm is to handle missing data points. The valid values are `breaching`, `notBreaching`, `ignore`, and `missing`. For more information, see [Configuring how CloudWatch alarms treat missing data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
     *
     * If this parameter is omitted, the default behavior of `missing` is used.
     */
    public val treatMissingData: kotlin.String? = builder.treatMissingData
    /**
     * The unit of the metric associated with the alarm.
     */
    public val unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.MetricAlarm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricAlarm(")
        append("actionsEnabled=$actionsEnabled,")
        append("alarmActions=$alarmActions,")
        append("alarmArn=$alarmArn,")
        append("alarmConfigurationUpdatedTimestamp=$alarmConfigurationUpdatedTimestamp,")
        append("alarmDescription=$alarmDescription,")
        append("alarmName=$alarmName,")
        append("comparisonOperator=$comparisonOperator,")
        append("datapointsToAlarm=$datapointsToAlarm,")
        append("dimensions=$dimensions,")
        append("evaluateLowSampleCountPercentile=$evaluateLowSampleCountPercentile,")
        append("evaluationPeriods=$evaluationPeriods,")
        append("evaluationState=$evaluationState,")
        append("extendedStatistic=$extendedStatistic,")
        append("insufficientDataActions=$insufficientDataActions,")
        append("metricName=$metricName,")
        append("metrics=$metrics,")
        append("namespace=$namespace,")
        append("okActions=$okActions,")
        append("period=$period,")
        append("stateReason=$stateReason,")
        append("stateReasonData=$stateReasonData,")
        append("stateTransitionedTimestamp=$stateTransitionedTimestamp,")
        append("stateUpdatedTimestamp=$stateUpdatedTimestamp,")
        append("stateValue=$stateValue,")
        append("statistic=$statistic,")
        append("threshold=$threshold,")
        append("thresholdMetricId=$thresholdMetricId,")
        append("treatMissingData=$treatMissingData,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionsEnabled?.hashCode() ?: 0
        result = 31 * result + (alarmActions?.hashCode() ?: 0)
        result = 31 * result + (alarmArn?.hashCode() ?: 0)
        result = 31 * result + (alarmConfigurationUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (alarmDescription?.hashCode() ?: 0)
        result = 31 * result + (alarmName?.hashCode() ?: 0)
        result = 31 * result + (comparisonOperator?.hashCode() ?: 0)
        result = 31 * result + (datapointsToAlarm ?: 0)
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (evaluateLowSampleCountPercentile?.hashCode() ?: 0)
        result = 31 * result + (evaluationPeriods ?: 0)
        result = 31 * result + (evaluationState?.hashCode() ?: 0)
        result = 31 * result + (extendedStatistic?.hashCode() ?: 0)
        result = 31 * result + (insufficientDataActions?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (okActions?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (stateReasonData?.hashCode() ?: 0)
        result = 31 * result + (stateTransitionedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (stateUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (stateValue?.hashCode() ?: 0)
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (threshold?.hashCode() ?: 0)
        result = 31 * result + (thresholdMetricId?.hashCode() ?: 0)
        result = 31 * result + (treatMissingData?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricAlarm

        if (actionsEnabled != other.actionsEnabled) return false
        if (alarmActions != other.alarmActions) return false
        if (alarmArn != other.alarmArn) return false
        if (alarmConfigurationUpdatedTimestamp != other.alarmConfigurationUpdatedTimestamp) return false
        if (alarmDescription != other.alarmDescription) return false
        if (alarmName != other.alarmName) return false
        if (comparisonOperator != other.comparisonOperator) return false
        if (datapointsToAlarm != other.datapointsToAlarm) return false
        if (dimensions != other.dimensions) return false
        if (evaluateLowSampleCountPercentile != other.evaluateLowSampleCountPercentile) return false
        if (evaluationPeriods != other.evaluationPeriods) return false
        if (evaluationState != other.evaluationState) return false
        if (extendedStatistic != other.extendedStatistic) return false
        if (insufficientDataActions != other.insufficientDataActions) return false
        if (metricName != other.metricName) return false
        if (metrics != other.metrics) return false
        if (namespace != other.namespace) return false
        if (okActions != other.okActions) return false
        if (period != other.period) return false
        if (stateReason != other.stateReason) return false
        if (stateReasonData != other.stateReasonData) return false
        if (stateTransitionedTimestamp != other.stateTransitionedTimestamp) return false
        if (stateUpdatedTimestamp != other.stateUpdatedTimestamp) return false
        if (stateValue != other.stateValue) return false
        if (statistic != other.statistic) return false
        if (threshold != other.threshold) return false
        if (thresholdMetricId != other.thresholdMetricId) return false
        if (treatMissingData != other.treatMissingData) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.MetricAlarm = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether actions should be executed during any changes to the alarm state.
         */
        public var actionsEnabled: kotlin.Boolean? = null
        /**
         * The actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         */
        public var alarmActions: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the alarm.
         */
        public var alarmArn: kotlin.String? = null
        /**
         * The time stamp of the last update to the alarm configuration.
         */
        public var alarmConfigurationUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the alarm.
         */
        public var alarmDescription: kotlin.String? = null
        /**
         * The name of the alarm.
         */
        public var alarmName: kotlin.String? = null
        /**
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.
         */
        public var comparisonOperator: aws.sdk.kotlin.services.cloudwatch.model.ComparisonOperator? = null
        /**
         * The number of data points that must be breaching to trigger the alarm.
         */
        public var datapointsToAlarm: kotlin.Int? = null
        /**
         * The dimensions for the metric associated with the alarm.
         */
        public var dimensions: List<Dimension>? = null
        /**
         * Used only for alarms based on percentiles. If `ignore`, the alarm state does not change during periods with too few data points to be statistically significant. If `evaluate` or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available.
         */
        public var evaluateLowSampleCountPercentile: kotlin.String? = null
        /**
         * The number of periods over which data is compared to the specified threshold.
         */
        public var evaluationPeriods: kotlin.Int? = null
        /**
         * If the value of this field is `PARTIAL_DATA`, the alarm is being evaluated based on only partial data. This happens if the query used for the alarm returns more than 10,000 metrics. For more information, see [Create alarms on Metrics Insights queries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Metrics_Insights_Alarm.html).
         */
        public var evaluationState: aws.sdk.kotlin.services.cloudwatch.model.EvaluationState? = null
        /**
         * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
         */
        public var extendedStatistic: kotlin.String? = null
        /**
         * The actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         */
        public var insufficientDataActions: List<String>? = null
        /**
         * The name of the metric associated with the alarm, if this is an alarm based on a single metric.
         */
        public var metricName: kotlin.String? = null
        /**
         * An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each structure either retrieves a metric or performs a math expression. One item in the Metrics array is the math expression that the alarm watches. This expression by designated by having `ReturnData` set to true.
         */
        public var metrics: List<MetricDataQuery>? = null
        /**
         * The namespace of the metric associated with the alarm.
         */
        public var namespace: kotlin.String? = null
        /**
         * The actions to execute when this alarm transitions to the `OK` state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         */
        public var okActions: List<String>? = null
        /**
         * The period, in seconds, over which the statistic is applied.
         */
        public var period: kotlin.Int? = null
        /**
         * An explanation for the alarm state, in text format.
         */
        public var stateReason: kotlin.String? = null
        /**
         * An explanation for the alarm state, in JSON format.
         */
        public var stateReasonData: kotlin.String? = null
        /**
         * The date and time that the alarm's `StateValue` most recently changed.
         */
        public var stateTransitionedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time stamp of the last update to the value of either the `StateValue` or `EvaluationState` parameters.
         */
        public var stateUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state value for the alarm.
         */
        public var stateValue: aws.sdk.kotlin.services.cloudwatch.model.StateValue? = null
        /**
         * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use `ExtendedStatistic`.
         */
        public var statistic: aws.sdk.kotlin.services.cloudwatch.model.Statistic? = null
        /**
         * The value to compare with the specified statistic.
         */
        public var threshold: kotlin.Double? = null
        /**
         * In an alarm based on an anomaly detection model, this is the ID of the `ANOMALY_DETECTION_BAND` function used as the threshold for the alarm.
         */
        public var thresholdMetricId: kotlin.String? = null
        /**
         * Sets how this alarm is to handle missing data points. The valid values are `breaching`, `notBreaching`, `ignore`, and `missing`. For more information, see [Configuring how CloudWatch alarms treat missing data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
         *
         * If this parameter is omitted, the default behavior of `missing` is used.
         */
        public var treatMissingData: kotlin.String? = null
        /**
         * The unit of the metric associated with the alarm.
         */
        public var unit: aws.sdk.kotlin.services.cloudwatch.model.StandardUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.MetricAlarm) : this() {
            this.actionsEnabled = x.actionsEnabled
            this.alarmActions = x.alarmActions
            this.alarmArn = x.alarmArn
            this.alarmConfigurationUpdatedTimestamp = x.alarmConfigurationUpdatedTimestamp
            this.alarmDescription = x.alarmDescription
            this.alarmName = x.alarmName
            this.comparisonOperator = x.comparisonOperator
            this.datapointsToAlarm = x.datapointsToAlarm
            this.dimensions = x.dimensions
            this.evaluateLowSampleCountPercentile = x.evaluateLowSampleCountPercentile
            this.evaluationPeriods = x.evaluationPeriods
            this.evaluationState = x.evaluationState
            this.extendedStatistic = x.extendedStatistic
            this.insufficientDataActions = x.insufficientDataActions
            this.metricName = x.metricName
            this.metrics = x.metrics
            this.namespace = x.namespace
            this.okActions = x.okActions
            this.period = x.period
            this.stateReason = x.stateReason
            this.stateReasonData = x.stateReasonData
            this.stateTransitionedTimestamp = x.stateTransitionedTimestamp
            this.stateUpdatedTimestamp = x.stateUpdatedTimestamp
            this.stateValue = x.stateValue
            this.statistic = x.statistic
            this.threshold = x.threshold
            this.thresholdMetricId = x.thresholdMetricId
            this.treatMissingData = x.treatMissingData
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.MetricAlarm = MetricAlarm(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
