// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



/**
 * Contains the information that's required to enable a managed Contributor Insights rule for an Amazon Web Services resource.
 */
public class ManagedRule private constructor(builder: Builder) {
    /**
     * The ARN of an Amazon Web Services resource that has managed Contributor Insights rules.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * A list of key-value pairs that you can associate with a managed Contributor Insights rule. You can associate as many as 50 tags with a rule. Tags can help you organize and categorize your resources. You also can use them to scope user permissions by granting a user permission to access or change only the resources that have certain tag values. To associate tags with a rule, you must have the `cloudwatch:TagResource` permission in addition to the `cloudwatch:PutInsightRule` permission. If you are using this operation to update an existing Contributor Insights rule, any tags that you specify in this parameter are ignored. To change the tags of an existing rule, use `TagResource`.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The template name for the managed Contributor Insights rule, as returned by `ListManagedInsightRules`.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.ManagedRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedRule(")
        append("resourceArn=$resourceArn,")
        append("tags=$tags,")
        append("templateName=$templateName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedRule

        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.ManagedRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of an Amazon Web Services resource that has managed Contributor Insights rules.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * A list of key-value pairs that you can associate with a managed Contributor Insights rule. You can associate as many as 50 tags with a rule. Tags can help you organize and categorize your resources. You also can use them to scope user permissions by granting a user permission to access or change only the resources that have certain tag values. To associate tags with a rule, you must have the `cloudwatch:TagResource` permission in addition to the `cloudwatch:PutInsightRule` permission. If you are using this operation to update an existing Contributor Insights rule, any tags that you specify in this parameter are ignored. To change the tags of an existing rule, use `TagResource`.
         */
        public var tags: List<Tag>? = null
        /**
         * The template name for the managed Contributor Insights rule, as returned by `ListManagedInsightRules`.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.ManagedRule) : this() {
            this.resourceArn = x.resourceArn
            this.tags = x.tags
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.ManagedRule = ManagedRule(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
