// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



public class GetMetricWidgetImageRequest private constructor(builder: Builder) {
    /**
     * A JSON string that defines the bitmap graph to be retrieved. The string includes the metrics to include in the graph, statistics, annotations, title, axis limits, and so on. You can include only one `MetricWidget` parameter in each `GetMetricWidgetImage` call.
     *
     * For more information about the syntax of `MetricWidget` see [GetMetricWidgetImage: Metric Widget Structure and Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Metric-Widget-Structure.html).
     *
     * If any metric on the graph could not load all the requested data points, an orange triangle with an exclamation point appears next to the graph legend.
     */
    public val metricWidget: kotlin.String? = builder.metricWidget
    /**
     * The format of the resulting image. Only PNG images are supported.
     *
     * The default is `png`. If you specify `png`, the API returns an HTTP response with the content-type set to `text/xml`. The image data is in a `MetricWidgetImage` field. For example:
     *
     * ` <GetMetricWidgetImageResponse xmlns=<URLstring>>`
     *
     * ` <GetMetricWidgetImageResult>`
     *
     * ` <MetricWidgetImage>`
     *
     * ` iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...`
     *
     * ` </MetricWidgetImage>`
     *
     * ` </GetMetricWidgetImageResult>`
     *
     * ` <ResponseMetadata>`
     *
     * ` <RequestId>6f0d4192-4d42-11e8-82c1-f539a07e0e3b</RequestId>`
     *
     * ` </ResponseMetadata>`
     *
     * `</GetMetricWidgetImageResponse>`
     *
     * The `image/png` setting is intended only for custom HTTP requests. For most use cases, and all actions using an Amazon Web Services SDK, you should use `png`. If you specify `image/png`, the HTTP response has a content-type set to `image/png`, and the body of the response is a PNG image.
     */
    public val outputFormat: kotlin.String? = builder.outputFormat

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.GetMetricWidgetImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMetricWidgetImageRequest(")
        append("metricWidget=$metricWidget,")
        append("outputFormat=$outputFormat")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricWidget?.hashCode() ?: 0
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMetricWidgetImageRequest

        if (metricWidget != other.metricWidget) return false
        if (outputFormat != other.outputFormat) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.GetMetricWidgetImageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A JSON string that defines the bitmap graph to be retrieved. The string includes the metrics to include in the graph, statistics, annotations, title, axis limits, and so on. You can include only one `MetricWidget` parameter in each `GetMetricWidgetImage` call.
         *
         * For more information about the syntax of `MetricWidget` see [GetMetricWidgetImage: Metric Widget Structure and Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Metric-Widget-Structure.html).
         *
         * If any metric on the graph could not load all the requested data points, an orange triangle with an exclamation point appears next to the graph legend.
         */
        public var metricWidget: kotlin.String? = null
        /**
         * The format of the resulting image. Only PNG images are supported.
         *
         * The default is `png`. If you specify `png`, the API returns an HTTP response with the content-type set to `text/xml`. The image data is in a `MetricWidgetImage` field. For example:
         *
         * ` <GetMetricWidgetImageResponse xmlns=<URLstring>>`
         *
         * ` <GetMetricWidgetImageResult>`
         *
         * ` <MetricWidgetImage>`
         *
         * ` iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...`
         *
         * ` </MetricWidgetImage>`
         *
         * ` </GetMetricWidgetImageResult>`
         *
         * ` <ResponseMetadata>`
         *
         * ` <RequestId>6f0d4192-4d42-11e8-82c1-f539a07e0e3b</RequestId>`
         *
         * ` </ResponseMetadata>`
         *
         * `</GetMetricWidgetImageResponse>`
         *
         * The `image/png` setting is intended only for custom HTTP requests. For most use cases, and all actions using an Amazon Web Services SDK, you should use `png`. If you specify `image/png`, the HTTP response has a content-type set to `image/png`, and the body of the response is a PNG image.
         */
        public var outputFormat: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.GetMetricWidgetImageRequest) : this() {
            this.metricWidget = x.metricWidget
            this.outputFormat = x.outputFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.GetMetricWidgetImageRequest = GetMetricWidgetImageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
