// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetMetricStreamResponse private constructor(builder: Builder) {
    /**
     * The ARN of the metric stream.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date that the metric stream was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are not streamed by this metric stream. In this case, all other metric namespaces in the account are streamed by this metric stream.
     */
    public val excludeFilters: List<MetricStreamFilter>? = builder.excludeFilters
    /**
     * The ARN of the Amazon Kinesis Data Firehose delivery stream that is used by this metric stream.
     */
    public val firehoseArn: kotlin.String? = builder.firehoseArn
    /**
     * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are streamed by this metric stream.
     */
    public val includeFilters: List<MetricStreamFilter>? = builder.includeFilters
    /**
     * If this is `true` and this metric stream is in a monitoring account, then the stream includes metrics from source accounts that the monitoring account is linked to.
     */
    public val includeLinkedAccountsMetrics: kotlin.Boolean? = builder.includeLinkedAccountsMetrics
    /**
     * The date of the most recent update to the metric stream's configuration.
     */
    public val lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateDate
    /**
     * The name of the metric stream.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The output format for the stream. Valid values are `json`, `opentelemetry1.0`, and `opentelemetry0.7`. For more information about metric stream output formats, see [Metric streams output formats](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
     */
    public val outputFormat: aws.sdk.kotlin.services.cloudwatch.model.MetricStreamOutputFormat? = builder.outputFormat
    /**
     * The ARN of the IAM role that is used by this metric stream.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The state of the metric stream. The possible values are `running` and `stopped`.
     */
    public val state: kotlin.String? = builder.state
    /**
     * Each entry in this array displays information about one or more metrics that include additional statistics in the metric stream. For more information about the additional statistics, see [ CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html).
     */
    public val statisticsConfigurations: List<MetricStreamStatisticsConfiguration>? = builder.statisticsConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.GetMetricStreamResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMetricStreamResponse(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("excludeFilters=$excludeFilters,")
        append("firehoseArn=$firehoseArn,")
        append("includeFilters=$includeFilters,")
        append("includeLinkedAccountsMetrics=$includeLinkedAccountsMetrics,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("name=$name,")
        append("outputFormat=$outputFormat,")
        append("roleArn=$roleArn,")
        append("state=$state,")
        append("statisticsConfigurations=$statisticsConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (excludeFilters?.hashCode() ?: 0)
        result = 31 * result + (firehoseArn?.hashCode() ?: 0)
        result = 31 * result + (includeFilters?.hashCode() ?: 0)
        result = 31 * result + (includeLinkedAccountsMetrics?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statisticsConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMetricStreamResponse

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (excludeFilters != other.excludeFilters) return false
        if (firehoseArn != other.firehoseArn) return false
        if (includeFilters != other.includeFilters) return false
        if (includeLinkedAccountsMetrics != other.includeLinkedAccountsMetrics) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (name != other.name) return false
        if (outputFormat != other.outputFormat) return false
        if (roleArn != other.roleArn) return false
        if (state != other.state) return false
        if (statisticsConfigurations != other.statisticsConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.GetMetricStreamResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the metric stream.
         */
        public var arn: kotlin.String? = null
        /**
         * The date that the metric stream was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are not streamed by this metric stream. In this case, all other metric namespaces in the account are streamed by this metric stream.
         */
        public var excludeFilters: List<MetricStreamFilter>? = null
        /**
         * The ARN of the Amazon Kinesis Data Firehose delivery stream that is used by this metric stream.
         */
        public var firehoseArn: kotlin.String? = null
        /**
         * If this array of metric namespaces is present, then these namespaces are the only metric namespaces that are streamed by this metric stream.
         */
        public var includeFilters: List<MetricStreamFilter>? = null
        /**
         * If this is `true` and this metric stream is in a monitoring account, then the stream includes metrics from source accounts that the monitoring account is linked to.
         */
        public var includeLinkedAccountsMetrics: kotlin.Boolean? = null
        /**
         * The date of the most recent update to the metric stream's configuration.
         */
        public var lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the metric stream.
         */
        public var name: kotlin.String? = null
        /**
         * The output format for the stream. Valid values are `json`, `opentelemetry1.0`, and `opentelemetry0.7`. For more information about metric stream output formats, see [Metric streams output formats](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
         */
        public var outputFormat: aws.sdk.kotlin.services.cloudwatch.model.MetricStreamOutputFormat? = null
        /**
         * The ARN of the IAM role that is used by this metric stream.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The state of the metric stream. The possible values are `running` and `stopped`.
         */
        public var state: kotlin.String? = null
        /**
         * Each entry in this array displays information about one or more metrics that include additional statistics in the metric stream. For more information about the additional statistics, see [ CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html).
         */
        public var statisticsConfigurations: List<MetricStreamStatisticsConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.GetMetricStreamResponse) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.excludeFilters = x.excludeFilters
            this.firehoseArn = x.firehoseArn
            this.includeFilters = x.includeFilters
            this.includeLinkedAccountsMetrics = x.includeLinkedAccountsMetrics
            this.lastUpdateDate = x.lastUpdateDate
            this.name = x.name
            this.outputFormat = x.outputFormat
            this.roleArn = x.roleArn
            this.state = x.state
            this.statisticsConfigurations = x.statisticsConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.GetMetricStreamResponse = GetMetricStreamResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
