// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetInsightRuleReportRequest private constructor(builder: Builder) {
    /**
     * The end time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as `yyyy-MM-dd'T'HH:mm:ss`. For example, `2019-07-01T23:59:59`.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The maximum number of contributors to include in the report. The range is 1 to 100. If you omit this, the default of 10 is used.
     */
    public val maxContributorCount: kotlin.Int? = builder.maxContributorCount
    /**
     * Specifies which metrics to use for aggregation of contributor values for the report. You can specify one or more of the following metrics:
     * + `UniqueContributors` -- the number of unique contributors for each data point.
     * + `MaxContributorValue` -- the value of the top contributor for each data point. The identity of the contributor might change for each data point in the graph.If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the most occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor with the highest sum in the log field specified by the rule's `Value`, during that period.
     * + `SampleCount` -- the number of data points matched by the rule.
     * + `Sum` -- the sum of the values from all contributors during the time period represented by that data point.
     * + `Minimum` -- the minimum value from a single observation during the time period represented by that data point.
     * + `Maximum` -- the maximum value from a single observation during the time period represented by that data point.
     * + `Average` -- the average value from all contributors during the time period represented by that data point.
     */
    public val metrics: List<String>? = builder.metrics
    /**
     * Determines what statistic to use to rank the contributors. Valid values are `Sum` and `Maximum`.
     */
    public val orderBy: kotlin.String? = builder.orderBy
    /**
     * The period, in seconds, to use for the statistics in the `InsightRuleMetricDatapoint` results.
     */
    public val period: kotlin.Int? = builder.period
    /**
     * The name of the rule that you want to see data from.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * The start time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as `yyyy-MM-dd'T'HH:mm:ss`. For example, `2019-07-01T23:59:59`.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.GetInsightRuleReportRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetInsightRuleReportRequest(")
        append("endTime=$endTime,")
        append("maxContributorCount=$maxContributorCount,")
        append("metrics=$metrics,")
        append("orderBy=$orderBy,")
        append("period=$period,")
        append("ruleName=$ruleName,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (maxContributorCount ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (orderBy?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetInsightRuleReportRequest

        if (endTime != other.endTime) return false
        if (maxContributorCount != other.maxContributorCount) return false
        if (metrics != other.metrics) return false
        if (orderBy != other.orderBy) return false
        if (period != other.period) return false
        if (ruleName != other.ruleName) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.GetInsightRuleReportRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as `yyyy-MM-dd'T'HH:mm:ss`. For example, `2019-07-01T23:59:59`.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum number of contributors to include in the report. The range is 1 to 100. If you omit this, the default of 10 is used.
         */
        public var maxContributorCount: kotlin.Int? = null
        /**
         * Specifies which metrics to use for aggregation of contributor values for the report. You can specify one or more of the following metrics:
         * + `UniqueContributors` -- the number of unique contributors for each data point.
         * + `MaxContributorValue` -- the value of the top contributor for each data point. The identity of the contributor might change for each data point in the graph.If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the most occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor with the highest sum in the log field specified by the rule's `Value`, during that period.
         * + `SampleCount` -- the number of data points matched by the rule.
         * + `Sum` -- the sum of the values from all contributors during the time period represented by that data point.
         * + `Minimum` -- the minimum value from a single observation during the time period represented by that data point.
         * + `Maximum` -- the maximum value from a single observation during the time period represented by that data point.
         * + `Average` -- the average value from all contributors during the time period represented by that data point.
         */
        public var metrics: List<String>? = null
        /**
         * Determines what statistic to use to rank the contributors. Valid values are `Sum` and `Maximum`.
         */
        public var orderBy: kotlin.String? = null
        /**
         * The period, in seconds, to use for the statistics in the `InsightRuleMetricDatapoint` results.
         */
        public var period: kotlin.Int? = null
        /**
         * The name of the rule that you want to see data from.
         */
        public var ruleName: kotlin.String? = null
        /**
         * The start time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as `yyyy-MM-dd'T'HH:mm:ss`. For example, `2019-07-01T23:59:59`.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.GetInsightRuleReportRequest) : this() {
            this.endTime = x.endTime
            this.maxContributorCount = x.maxContributorCount
            this.metrics = x.metrics
            this.orderBy = x.orderBy
            this.period = x.period
            this.ruleName = x.ruleName
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.GetInsightRuleReportRequest = GetInsightRuleReportRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
