// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details about a composite alarm.
 */
public class CompositeAlarm private constructor(builder: Builder) {
    /**
     * Indicates whether actions should be executed during any changes to the alarm state.
     */
    public val actionsEnabled: kotlin.Boolean? = builder.actionsEnabled
    /**
     * When the value is `ALARM`, it means that the actions are suppressed because the suppressor alarm is in `ALARM` When the value is `WaitPeriod`, it means that the actions are suppressed because the composite alarm is waiting for the suppressor alarm to go into into the `ALARM` state. The maximum waiting time is as specified in `ActionsSuppressorWaitPeriod`. After this time, the composite alarm performs its actions. When the value is `ExtensionPeriod`, it means that the actions are suppressed because the composite alarm is waiting after the suppressor alarm went out of the `ALARM` state. The maximum waiting time is as specified in `ActionsSuppressorExtensionPeriod`. After this time, the composite alarm performs its actions.
     */
    public val actionsSuppressedBy: aws.sdk.kotlin.services.cloudwatch.model.ActionsSuppressedBy? = builder.actionsSuppressedBy
    /**
     * Captures the reason for action suppression.
     */
    public val actionsSuppressedReason: kotlin.String? = builder.actionsSuppressedReason
    /**
     * Actions will be suppressed if the suppressor alarm is in the `ALARM` state. `ActionsSuppressor` can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
     */
    public val actionsSuppressor: kotlin.String? = builder.actionsSuppressor
    /**
     * The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
     *
     * `ExtensionPeriod` is required only when `ActionsSuppressor` is specified.
     */
    public val actionsSuppressorExtensionPeriod: kotlin.Int? = builder.actionsSuppressorExtensionPeriod
    /**
     * The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
     *
     * `WaitPeriod` is required only when `ActionsSuppressor` is specified.
     */
    public val actionsSuppressorWaitPeriod: kotlin.Int? = builder.actionsSuppressorWaitPeriod
    /**
     * The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public val alarmActions: List<String>? = builder.alarmActions
    /**
     * The Amazon Resource Name (ARN) of the alarm.
     */
    public val alarmArn: kotlin.String? = builder.alarmArn
    /**
     * The time stamp of the last update to the alarm configuration.
     */
    public val alarmConfigurationUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.alarmConfigurationUpdatedTimestamp
    /**
     * The description of the alarm.
     */
    public val alarmDescription: kotlin.String? = builder.alarmDescription
    /**
     * The name of the alarm.
     */
    public val alarmName: kotlin.String? = builder.alarmName
    /**
     * The rule that this alarm uses to evaluate its alarm state.
     */
    public val alarmRule: kotlin.String? = builder.alarmRule
    /**
     * The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public val insufficientDataActions: List<String>? = builder.insufficientDataActions
    /**
     * The actions to execute when this alarm transitions to the OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public val okActions: List<String>? = builder.okActions
    /**
     * An explanation for the alarm state, in text format.
     */
    public val stateReason: kotlin.String? = builder.stateReason
    /**
     * An explanation for the alarm state, in JSON format.
     */
    public val stateReasonData: kotlin.String? = builder.stateReasonData
    /**
     * The timestamp of the last change to the alarm's `StateValue`.
     */
    public val stateTransitionedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.stateTransitionedTimestamp
    /**
     * Tracks the timestamp of any state update, even if `StateValue` doesn't change.
     */
    public val stateUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.stateUpdatedTimestamp
    /**
     * The state value for the alarm.
     */
    public val stateValue: aws.sdk.kotlin.services.cloudwatch.model.StateValue? = builder.stateValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.CompositeAlarm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CompositeAlarm(")
        append("actionsEnabled=$actionsEnabled,")
        append("actionsSuppressedBy=$actionsSuppressedBy,")
        append("actionsSuppressedReason=$actionsSuppressedReason,")
        append("actionsSuppressor=$actionsSuppressor,")
        append("actionsSuppressorExtensionPeriod=$actionsSuppressorExtensionPeriod,")
        append("actionsSuppressorWaitPeriod=$actionsSuppressorWaitPeriod,")
        append("alarmActions=$alarmActions,")
        append("alarmArn=$alarmArn,")
        append("alarmConfigurationUpdatedTimestamp=$alarmConfigurationUpdatedTimestamp,")
        append("alarmDescription=$alarmDescription,")
        append("alarmName=$alarmName,")
        append("alarmRule=$alarmRule,")
        append("insufficientDataActions=$insufficientDataActions,")
        append("okActions=$okActions,")
        append("stateReason=$stateReason,")
        append("stateReasonData=$stateReasonData,")
        append("stateTransitionedTimestamp=$stateTransitionedTimestamp,")
        append("stateUpdatedTimestamp=$stateUpdatedTimestamp,")
        append("stateValue=$stateValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionsEnabled?.hashCode() ?: 0
        result = 31 * result + (actionsSuppressedBy?.hashCode() ?: 0)
        result = 31 * result + (actionsSuppressedReason?.hashCode() ?: 0)
        result = 31 * result + (actionsSuppressor?.hashCode() ?: 0)
        result = 31 * result + (actionsSuppressorExtensionPeriod ?: 0)
        result = 31 * result + (actionsSuppressorWaitPeriod ?: 0)
        result = 31 * result + (alarmActions?.hashCode() ?: 0)
        result = 31 * result + (alarmArn?.hashCode() ?: 0)
        result = 31 * result + (alarmConfigurationUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (alarmDescription?.hashCode() ?: 0)
        result = 31 * result + (alarmName?.hashCode() ?: 0)
        result = 31 * result + (alarmRule?.hashCode() ?: 0)
        result = 31 * result + (insufficientDataActions?.hashCode() ?: 0)
        result = 31 * result + (okActions?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (stateReasonData?.hashCode() ?: 0)
        result = 31 * result + (stateTransitionedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (stateUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (stateValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CompositeAlarm

        if (actionsEnabled != other.actionsEnabled) return false
        if (actionsSuppressedBy != other.actionsSuppressedBy) return false
        if (actionsSuppressedReason != other.actionsSuppressedReason) return false
        if (actionsSuppressor != other.actionsSuppressor) return false
        if (actionsSuppressorExtensionPeriod != other.actionsSuppressorExtensionPeriod) return false
        if (actionsSuppressorWaitPeriod != other.actionsSuppressorWaitPeriod) return false
        if (alarmActions != other.alarmActions) return false
        if (alarmArn != other.alarmArn) return false
        if (alarmConfigurationUpdatedTimestamp != other.alarmConfigurationUpdatedTimestamp) return false
        if (alarmDescription != other.alarmDescription) return false
        if (alarmName != other.alarmName) return false
        if (alarmRule != other.alarmRule) return false
        if (insufficientDataActions != other.insufficientDataActions) return false
        if (okActions != other.okActions) return false
        if (stateReason != other.stateReason) return false
        if (stateReasonData != other.stateReasonData) return false
        if (stateTransitionedTimestamp != other.stateTransitionedTimestamp) return false
        if (stateUpdatedTimestamp != other.stateUpdatedTimestamp) return false
        if (stateValue != other.stateValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.CompositeAlarm = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether actions should be executed during any changes to the alarm state.
         */
        public var actionsEnabled: kotlin.Boolean? = null
        /**
         * When the value is `ALARM`, it means that the actions are suppressed because the suppressor alarm is in `ALARM` When the value is `WaitPeriod`, it means that the actions are suppressed because the composite alarm is waiting for the suppressor alarm to go into into the `ALARM` state. The maximum waiting time is as specified in `ActionsSuppressorWaitPeriod`. After this time, the composite alarm performs its actions. When the value is `ExtensionPeriod`, it means that the actions are suppressed because the composite alarm is waiting after the suppressor alarm went out of the `ALARM` state. The maximum waiting time is as specified in `ActionsSuppressorExtensionPeriod`. After this time, the composite alarm performs its actions.
         */
        public var actionsSuppressedBy: aws.sdk.kotlin.services.cloudwatch.model.ActionsSuppressedBy? = null
        /**
         * Captures the reason for action suppression.
         */
        public var actionsSuppressedReason: kotlin.String? = null
        /**
         * Actions will be suppressed if the suppressor alarm is in the `ALARM` state. `ActionsSuppressor` can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
         */
        public var actionsSuppressor: kotlin.String? = null
        /**
         * The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
         *
         * `ExtensionPeriod` is required only when `ActionsSuppressor` is specified.
         */
        public var actionsSuppressorExtensionPeriod: kotlin.Int? = null
        /**
         * The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
         *
         * `WaitPeriod` is required only when `ActionsSuppressor` is specified.
         */
        public var actionsSuppressorWaitPeriod: kotlin.Int? = null
        /**
         * The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         */
        public var alarmActions: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the alarm.
         */
        public var alarmArn: kotlin.String? = null
        /**
         * The time stamp of the last update to the alarm configuration.
         */
        public var alarmConfigurationUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the alarm.
         */
        public var alarmDescription: kotlin.String? = null
        /**
         * The name of the alarm.
         */
        public var alarmName: kotlin.String? = null
        /**
         * The rule that this alarm uses to evaluate its alarm state.
         */
        public var alarmRule: kotlin.String? = null
        /**
         * The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         */
        public var insufficientDataActions: List<String>? = null
        /**
         * The actions to execute when this alarm transitions to the OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
         */
        public var okActions: List<String>? = null
        /**
         * An explanation for the alarm state, in text format.
         */
        public var stateReason: kotlin.String? = null
        /**
         * An explanation for the alarm state, in JSON format.
         */
        public var stateReasonData: kotlin.String? = null
        /**
         * The timestamp of the last change to the alarm's `StateValue`.
         */
        public var stateTransitionedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Tracks the timestamp of any state update, even if `StateValue` doesn't change.
         */
        public var stateUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state value for the alarm.
         */
        public var stateValue: aws.sdk.kotlin.services.cloudwatch.model.StateValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.CompositeAlarm) : this() {
            this.actionsEnabled = x.actionsEnabled
            this.actionsSuppressedBy = x.actionsSuppressedBy
            this.actionsSuppressedReason = x.actionsSuppressedReason
            this.actionsSuppressor = x.actionsSuppressor
            this.actionsSuppressorExtensionPeriod = x.actionsSuppressorExtensionPeriod
            this.actionsSuppressorWaitPeriod = x.actionsSuppressorWaitPeriod
            this.alarmActions = x.alarmActions
            this.alarmArn = x.alarmArn
            this.alarmConfigurationUpdatedTimestamp = x.alarmConfigurationUpdatedTimestamp
            this.alarmDescription = x.alarmDescription
            this.alarmName = x.alarmName
            this.alarmRule = x.alarmRule
            this.insufficientDataActions = x.insufficientDataActions
            this.okActions = x.okActions
            this.stateReason = x.stateReason
            this.stateReasonData = x.stateReasonData
            this.stateTransitionedTimestamp = x.stateTransitionedTimestamp
            this.stateUpdatedTimestamp = x.stateUpdatedTimestamp
            this.stateValue = x.stateValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.CompositeAlarm = CompositeAlarm(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
