// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



/**
 * The configuration specifies details about how the anomaly detection model is to be trained, including time ranges to exclude from use for training the model and the time zone to use for the metric.
 */
public class AnomalyDetectorConfiguration private constructor(builder: Builder) {
    /**
     * An array of time ranges to exclude from use when the anomaly detection model is trained. Use this to make sure that events that could cause unusual values for the metric, such as deployments, aren't used when CloudWatch creates the model.
     */
    public val excludedTimeRanges: List<Range>? = builder.excludedTimeRanges
    /**
     * The time zone to use for the metric. This is useful to enable the model to automatically account for daylight savings time changes if the metric is sensitive to such time changes.
     *
     * To specify a time zone, use the name of the time zone as specified in the standard tz database. For more information, see [tz database](https://en.wikipedia.org/wiki/Tz_database).
     */
    public val metricTimezone: kotlin.String? = builder.metricTimezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.AnomalyDetectorConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnomalyDetectorConfiguration(")
        append("excludedTimeRanges=$excludedTimeRanges,")
        append("metricTimezone=$metricTimezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludedTimeRanges?.hashCode() ?: 0
        result = 31 * result + (metricTimezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnomalyDetectorConfiguration

        if (excludedTimeRanges != other.excludedTimeRanges) return false
        if (metricTimezone != other.metricTimezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.AnomalyDetectorConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of time ranges to exclude from use when the anomaly detection model is trained. Use this to make sure that events that could cause unusual values for the metric, such as deployments, aren't used when CloudWatch creates the model.
         */
        public var excludedTimeRanges: List<Range>? = null
        /**
         * The time zone to use for the metric. This is useful to enable the model to automatically account for daylight savings time changes if the metric is sensitive to such time changes.
         *
         * To specify a time zone, use the name of the time zone as specified in the standard tz database. For more information, see [tz database](https://en.wikipedia.org/wiki/Tz_database).
         */
        public var metricTimezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.AnomalyDetectorConfiguration) : this() {
            this.excludedTimeRanges = x.excludedTimeRanges
            this.metricTimezone = x.metricTimezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.AnomalyDetectorConfiguration = AnomalyDetectorConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
