// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.DashboardType
import aws.sdk.kotlin.services.cloudtrail.model.RefreshSchedule
import aws.sdk.kotlin.services.cloudtrail.model.UpdateDashboardResponse
import aws.sdk.kotlin.services.cloudtrail.model.Widget
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class UpdateDashboardOperationDeserializer: HttpDeserializer.NonStreaming<UpdateDashboardResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateDashboardResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDashboardError(context, call, payload)
        }
        val builder = UpdateDashboardResponse.Builder()

        if (payload != null) {
            deserializeUpdateDashboardOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateDashboardError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientEncryptionPolicyException" -> InsufficientEncryptionPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidQueryStatementException" -> InvalidQueryStatementExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDashboardOperationBody(builder: UpdateDashboardResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val DASHBOARDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DashboardArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val REFRESHSCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RefreshSchedule"))
    val TERMINATIONPROTECTIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("TerminationProtectionEnabled"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val UPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedTimestamp"))
    val WIDGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Widgets"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DASHBOARDARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REFRESHSCHEDULE_DESCRIPTOR)
        field(TERMINATIONPROTECTIONENABLED_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(UPDATEDTIMESTAMP_DESCRIPTOR)
        field(WIDGETS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DASHBOARDARN_DESCRIPTOR.index -> builder.dashboardArn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REFRESHSCHEDULE_DESCRIPTOR.index -> builder.refreshSchedule = deserializeRefreshScheduleDocument(deserializer)
                TERMINATIONPROTECTIONENABLED_DESCRIPTOR.index -> builder.terminationProtectionEnabled = deserializeBoolean()
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { DashboardType.fromValue(it) }
                UPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.updatedTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                WIDGETS_DESCRIPTOR.index -> builder.widgets =
                    deserializer.deserializeList(WIDGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<Widget>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWidgetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
