// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.StopEventDataStoreIngestionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class StopEventDataStoreIngestionOperationDeserializer: HttpDeserializer.NonStreaming<StopEventDataStoreIngestionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StopEventDataStoreIngestionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStopEventDataStoreIngestionError(context, call, payload)
        }
        val builder = StopEventDataStoreIngestionResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStopEventDataStoreIngestionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientDependencyServiceAccessPermissionException" -> InsufficientDependencyServiceAccessPermissionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEventDataStoreCategoryException" -> InvalidEventDataStoreCategoryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEventDataStoreStatusException" -> InvalidEventDataStoreStatusExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotOrganizationMasterAccountException" -> NotOrganizationMasterAccountExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
