// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.ImportSource
import aws.sdk.kotlin.services.cloudtrail.model.ImportStatus
import aws.sdk.kotlin.services.cloudtrail.model.StartImportResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class StartImportOperationDeserializer: HttpDeserializer.NonStreaming<StartImportResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartImportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartImportError(context, call, payload)
        }
        val builder = StartImportResponse.Builder()

        if (payload != null) {
            deserializeStartImportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartImportError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccountHasOngoingImportException" -> AccountHasOngoingImportExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ImportNotFoundException" -> ImportNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientEncryptionPolicyException" -> InsufficientEncryptionPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEventDataStoreCategoryException" -> InvalidEventDataStoreCategoryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEventDataStoreStatusException" -> InvalidEventDataStoreStatusExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidImportSourceException" -> InvalidImportSourceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartImportOperationBody(builder: StartImportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Destinations"))
    val ENDEVENTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndEventTime"))
    val IMPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImportId"))
    val IMPORTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ImportSource"))
    val IMPORTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ImportStatus"))
    val STARTEVENTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartEventTime"))
    val UPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedTimestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(ENDEVENTTIME_DESCRIPTOR)
        field(IMPORTID_DESCRIPTOR)
        field(IMPORTSOURCE_DESCRIPTOR)
        field(IMPORTSTATUS_DESCRIPTOR)
        field(STARTEVENTTIME_DESCRIPTOR)
        field(UPDATEDTIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESTINATIONS_DESCRIPTOR.index -> builder.destinations =
                    deserializer.deserializeList(DESTINATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENDEVENTTIME_DESCRIPTOR.index -> builder.endEventTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                IMPORTID_DESCRIPTOR.index -> builder.importId = deserializeString()
                IMPORTSOURCE_DESCRIPTOR.index -> builder.importSource = deserializeImportSourceDocument(deserializer)
                IMPORTSTATUS_DESCRIPTOR.index -> builder.importStatus = deserializeString().let { ImportStatus.fromValue(it) }
                STARTEVENTTIME_DESCRIPTOR.index -> builder.startEventTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                UPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.updatedTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
