// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.RegisterOrganizationDelegatedAdminResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class RegisterOrganizationDelegatedAdminOperationDeserializer: HttpDeserializer.NonStreaming<RegisterOrganizationDelegatedAdminResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RegisterOrganizationDelegatedAdminResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRegisterOrganizationDelegatedAdminError(context, call, payload)
        }
        val builder = RegisterOrganizationDelegatedAdminResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRegisterOrganizationDelegatedAdminError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccountNotFoundException" -> AccountNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccountRegisteredException" -> AccountRegisteredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CannotDelegateManagementAccountException" -> CannotDelegateManagementAccountExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudTrailAccessNotEnabledException" -> CloudTrailAccessNotEnabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DelegatedAdminAccountLimitExceededException" -> DelegatedAdminAccountLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientDependencyServiceAccessPermissionException" -> InsufficientDependencyServiceAccessPermissionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientIAMAccessPermissionException" -> InsufficientIamAccessPermissionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotOrganizationManagementAccountException" -> NotOrganizationManagementAccountExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotInAllFeaturesModeException" -> OrganizationNotInAllFeaturesModeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationsNotInUseException" -> OrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
