// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.InsightSelector
import aws.sdk.kotlin.services.cloudtrail.model.PutInsightSelectorsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PutInsightSelectorsOperationDeserializer: HttpDeserializer.NonStreaming<PutInsightSelectorsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutInsightSelectorsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutInsightSelectorsError(context, call, payload)
        }
        val builder = PutInsightSelectorsResponse.Builder()

        if (payload != null) {
            deserializePutInsightSelectorsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutInsightSelectorsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudTrailARNInvalidException" -> CloudTrailArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientEncryptionPolicyException" -> InsufficientEncryptionPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientS3BucketPolicyException" -> InsufficientS3BucketPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidHomeRegionException" -> InvalidHomeRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInsightSelectorsException" -> InvalidInsightSelectorsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombinationException" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTrailNameException" -> InvalidTrailNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsException" -> KmsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotOrganizationMasterAccountException" -> NotOrganizationMasterAccountExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "S3BucketDoesNotExistException" -> S3BucketDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TrailNotFoundException" -> TrailNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutInsightSelectorsOperationBody(builder: PutInsightSelectorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVENTDATASTOREARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventDataStoreArn"))
    val INSIGHTSELECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InsightSelectors"))
    val INSIGHTSDESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InsightsDestination"))
    val TRAILARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrailARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTDATASTOREARN_DESCRIPTOR)
        field(INSIGHTSELECTORS_DESCRIPTOR)
        field(INSIGHTSDESTINATION_DESCRIPTOR)
        field(TRAILARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVENTDATASTOREARN_DESCRIPTOR.index -> builder.eventDataStoreArn = deserializeString()
                INSIGHTSELECTORS_DESCRIPTOR.index -> builder.insightSelectors =
                    deserializer.deserializeList(INSIGHTSELECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<InsightSelector>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInsightSelectorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INSIGHTSDESTINATION_DESCRIPTOR.index -> builder.insightsDestination = deserializeString()
                TRAILARN_DESCRIPTOR.index -> builder.trailArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
