// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.InsightType
import aws.sdk.kotlin.services.cloudtrail.model.ListInsightsMetricDataResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class ListInsightsMetricDataOperationDeserializer: HttpDeserializer.NonStreaming<ListInsightsMetricDataResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListInsightsMetricDataResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListInsightsMetricDataError(context, call, payload)
        }
        val builder = ListInsightsMetricDataResponse.Builder()

        if (payload != null) {
            deserializeListInsightsMetricDataOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListInsightsMetricDataError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListInsightsMetricDataOperationBody(builder: ListInsightsMetricDataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorCode"))
    val EVENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventName"))
    val EVENTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventSource"))
    val INSIGHTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("InsightType"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val TIMESTAMPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Timestamps"))
    val VALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Values"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORCODE_DESCRIPTOR)
        field(EVENTNAME_DESCRIPTOR)
        field(EVENTSOURCE_DESCRIPTOR)
        field(INSIGHTTYPE_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(TIMESTAMPS_DESCRIPTOR)
        field(VALUES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORCODE_DESCRIPTOR.index -> builder.errorCode = deserializeString()
                EVENTNAME_DESCRIPTOR.index -> builder.eventName = deserializeString()
                EVENTSOURCE_DESCRIPTOR.index -> builder.eventSource = deserializeString()
                INSIGHTTYPE_DESCRIPTOR.index -> builder.insightType = deserializeString().let { InsightType.fromValue(it) }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TIMESTAMPS_DESCRIPTOR.index -> builder.timestamps =
                    deserializer.deserializeList(TIMESTAMPS_DESCRIPTOR) {
                        val col0 = mutableListOf<Instant>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstant(TimestampFormat.EPOCH_SECONDS) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VALUES_DESCRIPTOR.index -> builder.values =
                    deserializer.deserializeList(VALUES_DESCRIPTOR) {
                        val col0 = mutableListOf<Double>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDouble() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
