// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.GetTrailStatusResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetTrailStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetTrailStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTrailStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTrailStatusError(context, call, payload)
        }
        val builder = GetTrailStatusResponse.Builder()

        if (payload != null) {
            deserializeGetTrailStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTrailStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudTrailARNInvalidException" -> CloudTrailArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTrailNameException" -> InvalidTrailNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TrailNotFoundException" -> TrailNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTrailStatusOperationBody(builder: GetTrailStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ISLOGGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsLogging"))
    val LATESTCLOUDWATCHLOGSDELIVERYERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestCloudWatchLogsDeliveryError"))
    val LATESTCLOUDWATCHLOGSDELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestCloudWatchLogsDeliveryTime"))
    val LATESTDELIVERYATTEMPTSUCCEEDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestDeliveryAttemptSucceeded"))
    val LATESTDELIVERYATTEMPTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestDeliveryAttemptTime"))
    val LATESTDELIVERYERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestDeliveryError"))
    val LATESTDELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestDeliveryTime"))
    val LATESTDIGESTDELIVERYERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestDigestDeliveryError"))
    val LATESTDIGESTDELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestDigestDeliveryTime"))
    val LATESTNOTIFICATIONATTEMPTSUCCEEDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestNotificationAttemptSucceeded"))
    val LATESTNOTIFICATIONATTEMPTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestNotificationAttemptTime"))
    val LATESTNOTIFICATIONERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestNotificationError"))
    val LATESTNOTIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestNotificationTime"))
    val STARTLOGGINGTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartLoggingTime"))
    val STOPLOGGINGTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StopLoggingTime"))
    val TIMELOGGINGSTARTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TimeLoggingStarted"))
    val TIMELOGGINGSTOPPED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TimeLoggingStopped"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ISLOGGING_DESCRIPTOR)
        field(LATESTCLOUDWATCHLOGSDELIVERYERROR_DESCRIPTOR)
        field(LATESTCLOUDWATCHLOGSDELIVERYTIME_DESCRIPTOR)
        field(LATESTDELIVERYATTEMPTSUCCEEDED_DESCRIPTOR)
        field(LATESTDELIVERYATTEMPTTIME_DESCRIPTOR)
        field(LATESTDELIVERYERROR_DESCRIPTOR)
        field(LATESTDELIVERYTIME_DESCRIPTOR)
        field(LATESTDIGESTDELIVERYERROR_DESCRIPTOR)
        field(LATESTDIGESTDELIVERYTIME_DESCRIPTOR)
        field(LATESTNOTIFICATIONATTEMPTSUCCEEDED_DESCRIPTOR)
        field(LATESTNOTIFICATIONATTEMPTTIME_DESCRIPTOR)
        field(LATESTNOTIFICATIONERROR_DESCRIPTOR)
        field(LATESTNOTIFICATIONTIME_DESCRIPTOR)
        field(STARTLOGGINGTIME_DESCRIPTOR)
        field(STOPLOGGINGTIME_DESCRIPTOR)
        field(TIMELOGGINGSTARTED_DESCRIPTOR)
        field(TIMELOGGINGSTOPPED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ISLOGGING_DESCRIPTOR.index -> builder.isLogging = deserializeBoolean()
                LATESTCLOUDWATCHLOGSDELIVERYERROR_DESCRIPTOR.index -> builder.latestCloudWatchLogsDeliveryError = deserializeString()
                LATESTCLOUDWATCHLOGSDELIVERYTIME_DESCRIPTOR.index -> builder.latestCloudWatchLogsDeliveryTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LATESTDELIVERYATTEMPTSUCCEEDED_DESCRIPTOR.index -> builder.latestDeliveryAttemptSucceeded = deserializeString()
                LATESTDELIVERYATTEMPTTIME_DESCRIPTOR.index -> builder.latestDeliveryAttemptTime = deserializeString()
                LATESTDELIVERYERROR_DESCRIPTOR.index -> builder.latestDeliveryError = deserializeString()
                LATESTDELIVERYTIME_DESCRIPTOR.index -> builder.latestDeliveryTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LATESTDIGESTDELIVERYERROR_DESCRIPTOR.index -> builder.latestDigestDeliveryError = deserializeString()
                LATESTDIGESTDELIVERYTIME_DESCRIPTOR.index -> builder.latestDigestDeliveryTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LATESTNOTIFICATIONATTEMPTSUCCEEDED_DESCRIPTOR.index -> builder.latestNotificationAttemptSucceeded = deserializeString()
                LATESTNOTIFICATIONATTEMPTTIME_DESCRIPTOR.index -> builder.latestNotificationAttemptTime = deserializeString()
                LATESTNOTIFICATIONERROR_DESCRIPTOR.index -> builder.latestNotificationError = deserializeString()
                LATESTNOTIFICATIONTIME_DESCRIPTOR.index -> builder.latestNotificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STARTLOGGINGTIME_DESCRIPTOR.index -> builder.startLoggingTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STOPLOGGINGTIME_DESCRIPTOR.index -> builder.stopLoggingTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                TIMELOGGINGSTARTED_DESCRIPTOR.index -> builder.timeLoggingStarted = deserializeString()
                TIMELOGGINGSTOPPED_DESCRIPTOR.index -> builder.timeLoggingStopped = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
