// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.GetResourcePolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetResourcePolicyOperationDeserializer: HttpDeserializer.NonStreaming<GetResourcePolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetResourcePolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetResourcePolicyError(context, call, payload)
        }
        val builder = GetResourcePolicyResponse.Builder()

        if (payload != null) {
            deserializeGetResourcePolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetResourcePolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceARNNotValidException" -> ResourceArnNotValidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourcePolicyNotFoundException" -> ResourcePolicyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceTypeNotSupportedException" -> ResourceTypeNotSupportedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourcePolicyOperationBody(builder: GetResourcePolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELEGATEDADMINRESOURCEPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DelegatedAdminResourcePolicy"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val RESOURCEPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourcePolicy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELEGATEDADMINRESOURCEPOLICY_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(RESOURCEPOLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELEGATEDADMINRESOURCEPOLICY_DESCRIPTOR.index -> builder.delegatedAdminResourcePolicy = deserializeString()
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                RESOURCEPOLICY_DESCRIPTOR.index -> builder.resourcePolicy = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
