// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector
import aws.sdk.kotlin.services.cloudtrail.model.BillingMode
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.EventDataStoreStatus
import aws.sdk.kotlin.services.cloudtrail.model.FederationStatus
import aws.sdk.kotlin.services.cloudtrail.model.GetEventDataStoreResponse
import aws.sdk.kotlin.services.cloudtrail.model.PartitionKey
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetEventDataStoreOperationDeserializer: HttpDeserializer.NonStreaming<GetEventDataStoreResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetEventDataStoreResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEventDataStoreError(context, call, payload)
        }
        val builder = GetEventDataStoreResponse.Builder()

        if (payload != null) {
            deserializeGetEventDataStoreOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetEventDataStoreError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEventDataStoreOperationBody(builder: GetEventDataStoreResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADVANCEDEVENTSELECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdvancedEventSelectors"))
    val BILLINGMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("BillingMode"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val EVENTDATASTOREARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventDataStoreArn"))
    val FEDERATIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FederationRoleArn"))
    val FEDERATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FederationStatus"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val MULTIREGIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("MultiRegionEnabled"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val ORGANIZATIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("OrganizationEnabled"))
    val PARTITIONKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PartitionKeys"))
    val RETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RetentionPeriod"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TERMINATIONPROTECTIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("TerminationProtectionEnabled"))
    val UPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedTimestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADVANCEDEVENTSELECTORS_DESCRIPTOR)
        field(BILLINGMODE_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(EVENTDATASTOREARN_DESCRIPTOR)
        field(FEDERATIONROLEARN_DESCRIPTOR)
        field(FEDERATIONSTATUS_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(MULTIREGIONENABLED_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ORGANIZATIONENABLED_DESCRIPTOR)
        field(PARTITIONKEYS_DESCRIPTOR)
        field(RETENTIONPERIOD_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TERMINATIONPROTECTIONENABLED_DESCRIPTOR)
        field(UPDATEDTIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADVANCEDEVENTSELECTORS_DESCRIPTOR.index -> builder.advancedEventSelectors =
                    deserializer.deserializeList(ADVANCEDEVENTSELECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<AdvancedEventSelector>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAdvancedEventSelectorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BILLINGMODE_DESCRIPTOR.index -> builder.billingMode = deserializeString().let { BillingMode.fromValue(it) }
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                EVENTDATASTOREARN_DESCRIPTOR.index -> builder.eventDataStoreArn = deserializeString()
                FEDERATIONROLEARN_DESCRIPTOR.index -> builder.federationRoleArn = deserializeString()
                FEDERATIONSTATUS_DESCRIPTOR.index -> builder.federationStatus = deserializeString().let { FederationStatus.fromValue(it) }
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                MULTIREGIONENABLED_DESCRIPTOR.index -> builder.multiRegionEnabled = deserializeBoolean()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ORGANIZATIONENABLED_DESCRIPTOR.index -> builder.organizationEnabled = deserializeBoolean()
                PARTITIONKEYS_DESCRIPTOR.index -> builder.partitionKeys =
                    deserializer.deserializeList(PARTITIONKEYS_DESCRIPTOR) {
                        val col0 = mutableListOf<PartitionKey>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePartitionKeyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RETENTIONPERIOD_DESCRIPTOR.index -> builder.retentionPeriod = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EventDataStoreStatus.fromValue(it) }
                TERMINATIONPROTECTIONENABLED_DESCRIPTOR.index -> builder.terminationProtectionEnabled = deserializeBoolean()
                UPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.updatedTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
