// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.ContextKeySelector
import aws.sdk.kotlin.services.cloudtrail.model.GetEventConfigurationResponse
import aws.sdk.kotlin.services.cloudtrail.model.MaxEventSize
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetEventConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<GetEventConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetEventConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEventConfigurationError(context, call, payload)
        }
        val builder = GetEventConfigurationResponse.Builder()

        if (payload != null) {
            deserializeGetEventConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetEventConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudTrailARNInvalidException" -> CloudTrailArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEventDataStoreCategoryException" -> InvalidEventDataStoreCategoryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEventDataStoreStatusException" -> InvalidEventDataStoreStatusExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombinationException" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEventConfigurationOperationBody(builder: GetEventConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTEXTKEYSELECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ContextKeySelectors"))
    val EVENTDATASTOREARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventDataStoreArn"))
    val MAXEVENTSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MaxEventSize"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTEXTKEYSELECTORS_DESCRIPTOR)
        field(EVENTDATASTOREARN_DESCRIPTOR)
        field(MAXEVENTSIZE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTEXTKEYSELECTORS_DESCRIPTOR.index -> builder.contextKeySelectors =
                    deserializer.deserializeList(CONTEXTKEYSELECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<ContextKeySelector>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeContextKeySelectorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                EVENTDATASTOREARN_DESCRIPTOR.index -> builder.eventDataStoreArn = deserializeString()
                MAXEVENTSIZE_DESCRIPTOR.index -> builder.maxEventSize = deserializeString().let { MaxEventSize.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
