// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.Destination
import aws.sdk.kotlin.services.cloudtrail.model.GetChannelResponse
import aws.sdk.kotlin.services.cloudtrail.model.IngestionStatus
import aws.sdk.kotlin.services.cloudtrail.model.SourceConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetChannelOperationDeserializer: HttpDeserializer.NonStreaming<GetChannelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetChannelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetChannelError(context, call, payload)
        }
        val builder = GetChannelResponse.Builder()

        if (payload != null) {
            deserializeGetChannelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetChannelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ChannelARNInvalidException" -> ChannelArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ChannelNotFoundException" -> ChannelNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetChannelOperationBody(builder: GetChannelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelArn"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Destinations"))
    val INGESTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IngestionStatus"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Source"))
    val SOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELARN_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(INGESTIONSTATUS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(SOURCECONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNELARN_DESCRIPTOR.index -> builder.channelArn = deserializeString()
                DESTINATIONS_DESCRIPTOR.index -> builder.destinations =
                    deserializer.deserializeList(DESTINATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Destination>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDestinationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INGESTIONSTATUS_DESCRIPTOR.index -> builder.ingestionStatus = deserializeIngestionStatusDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SOURCE_DESCRIPTOR.index -> builder.source = deserializeString()
                SOURCECONFIG_DESCRIPTOR.index -> builder.sourceConfig = deserializeSourceConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
