// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.DeliveryStatus
import aws.sdk.kotlin.services.cloudtrail.model.DescribeQueryResponse
import aws.sdk.kotlin.services.cloudtrail.model.QueryStatisticsForDescribeQuery
import aws.sdk.kotlin.services.cloudtrail.model.QueryStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeQueryOperationDeserializer: HttpDeserializer.NonStreaming<DescribeQueryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeQueryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeQueryError(context, call, payload)
        }
        val builder = DescribeQueryResponse.Builder()

        if (payload != null) {
            deserializeDescribeQueryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeQueryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "QueryIdNotFoundException" -> QueryIdNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeQueryOperationBody(builder: DescribeQueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELIVERYS3URI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeliveryS3Uri"))
    val DELIVERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DeliveryStatus"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val EVENTDATASTOREOWNERACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventDataStoreOwnerAccountId"))
    val PROMPT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Prompt"))
    val QUERYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryId"))
    val QUERYSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueryStatistics"))
    val QUERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("QueryStatus"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryString"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELIVERYS3URI_DESCRIPTOR)
        field(DELIVERYSTATUS_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(EVENTDATASTOREOWNERACCOUNTID_DESCRIPTOR)
        field(PROMPT_DESCRIPTOR)
        field(QUERYID_DESCRIPTOR)
        field(QUERYSTATISTICS_DESCRIPTOR)
        field(QUERYSTATUS_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELIVERYS3URI_DESCRIPTOR.index -> builder.deliveryS3Uri = deserializeString()
                DELIVERYSTATUS_DESCRIPTOR.index -> builder.deliveryStatus = deserializeString().let { DeliveryStatus.fromValue(it) }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                EVENTDATASTOREOWNERACCOUNTID_DESCRIPTOR.index -> builder.eventDataStoreOwnerAccountId = deserializeString()
                PROMPT_DESCRIPTOR.index -> builder.prompt = deserializeString()
                QUERYID_DESCRIPTOR.index -> builder.queryId = deserializeString()
                QUERYSTATISTICS_DESCRIPTOR.index -> builder.queryStatistics = deserializeQueryStatisticsForDescribeQueryDocument(deserializer)
                QUERYSTATUS_DESCRIPTOR.index -> builder.queryStatus = deserializeString().let { QueryStatus.fromValue(it) }
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
