// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.CreateTrailResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateTrailOperationDeserializer: HttpDeserializer.NonStreaming<CreateTrailResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateTrailResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateTrailError(context, call, payload)
        }
        val builder = CreateTrailResponse.Builder()

        if (payload != null) {
            deserializeCreateTrailOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateTrailError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudTrailAccessNotEnabledException" -> CloudTrailAccessNotEnabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudTrailInvalidClientTokenIdException" -> CloudTrailInvalidClientTokenIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudWatchLogsDeliveryUnavailableException" -> CloudWatchLogsDeliveryUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientDependencyServiceAccessPermissionException" -> InsufficientDependencyServiceAccessPermissionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientEncryptionPolicyException" -> InsufficientEncryptionPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientS3BucketPolicyException" -> InsufficientS3BucketPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientSnsTopicPolicyException" -> InsufficientSnsTopicPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCloudWatchLogsLogGroupArnException" -> InvalidCloudWatchLogsLogGroupArnExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCloudWatchLogsRoleArnException" -> InvalidCloudWatchLogsRoleArnExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidKmsKeyIdException" -> InvalidKmsKeyIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombinationException" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3BucketNameException" -> InvalidS3BucketNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3PrefixException" -> InvalidS3PrefixExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSnsTopicNameException" -> InvalidSnsTopicNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagParameterException" -> InvalidTagParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTrailNameException" -> InvalidTrailNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsException" -> KmsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsKeyDisabledException" -> KmsKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KmsKeyNotFoundException" -> KmsKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaximumNumberOfTrailsExceededException" -> MaximumNumberOfTrailsExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotOrganizationMasterAccountException" -> NotOrganizationMasterAccountExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationNotInAllFeaturesModeException" -> OrganizationNotInAllFeaturesModeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OrganizationsNotInUseException" -> OrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "S3BucketDoesNotExistException" -> S3BucketDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TagsLimitExceededException" -> TagsLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TrailAlreadyExistsException" -> TrailAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TrailNotProvidedException" -> TrailNotProvidedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateTrailOperationBody(builder: CreateTrailResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLOUDWATCHLOGSLOGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CloudWatchLogsLogGroupArn"))
    val CLOUDWATCHLOGSROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CloudWatchLogsRoleArn"))
    val INCLUDEGLOBALSERVICEEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeGlobalServiceEvents"))
    val ISMULTIREGIONTRAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsMultiRegionTrail"))
    val ISORGANIZATIONTRAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsOrganizationTrail"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val LOGFILEVALIDATIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("LogFileValidationEnabled"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val S3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3BucketName"))
    val S3KEYPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3KeyPrefix"))
    val SNSTOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnsTopicARN"))
    val SNSTOPICNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnsTopicName"))
    val TRAILARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrailARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLOUDWATCHLOGSLOGGROUPARN_DESCRIPTOR)
        field(CLOUDWATCHLOGSROLEARN_DESCRIPTOR)
        field(INCLUDEGLOBALSERVICEEVENTS_DESCRIPTOR)
        field(ISMULTIREGIONTRAIL_DESCRIPTOR)
        field(ISORGANIZATIONTRAIL_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LOGFILEVALIDATIONENABLED_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(S3BUCKETNAME_DESCRIPTOR)
        field(S3KEYPREFIX_DESCRIPTOR)
        field(SNSTOPICARN_DESCRIPTOR)
        field(SNSTOPICNAME_DESCRIPTOR)
        field(TRAILARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLOUDWATCHLOGSLOGGROUPARN_DESCRIPTOR.index -> builder.cloudWatchLogsLogGroupArn = deserializeString()
                CLOUDWATCHLOGSROLEARN_DESCRIPTOR.index -> builder.cloudWatchLogsRoleArn = deserializeString()
                INCLUDEGLOBALSERVICEEVENTS_DESCRIPTOR.index -> builder.includeGlobalServiceEvents = deserializeBoolean()
                ISMULTIREGIONTRAIL_DESCRIPTOR.index -> builder.isMultiRegionTrail = deserializeBoolean()
                ISORGANIZATIONTRAIL_DESCRIPTOR.index -> builder.isOrganizationTrail = deserializeBoolean()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LOGFILEVALIDATIONENABLED_DESCRIPTOR.index -> builder.logFileValidationEnabled = deserializeBoolean()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                S3BUCKETNAME_DESCRIPTOR.index -> builder.s3BucketName = deserializeString()
                S3KEYPREFIX_DESCRIPTOR.index -> builder.s3KeyPrefix = deserializeString()
                SNSTOPICARN_DESCRIPTOR.index -> builder.snsTopicArn = deserializeString()
                SNSTOPICNAME_DESCRIPTOR.index -> builder.snsTopicName = deserializeString()
                TRAILARN_DESCRIPTOR.index -> builder.trailArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
