// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CancelQueryResponse
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.QueryStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CancelQueryOperationDeserializer: HttpDeserializer.NonStreaming<CancelQueryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CancelQueryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCancelQueryError(context, call, payload)
        }
        val builder = CancelQueryResponse.Builder()

        if (payload != null) {
            deserializeCancelQueryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCancelQueryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InactiveQueryException" -> InactiveQueryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "QueryIdNotFoundException" -> QueryIdNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCancelQueryOperationBody(builder: CancelQueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVENTDATASTOREOWNERACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventDataStoreOwnerAccountId"))
    val QUERYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryId"))
    val QUERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("QueryStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTDATASTOREOWNERACCOUNTID_DESCRIPTOR)
        field(QUERYID_DESCRIPTOR)
        field(QUERYSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVENTDATASTOREOWNERACCOUNTID_DESCRIPTOR.index -> builder.eventDataStoreOwnerAccountId = deserializeString()
                QUERYID_DESCRIPTOR.index -> builder.queryId = deserializeString()
                QUERYSTATUS_DESCRIPTOR.index -> builder.queryStatus = deserializeString().let { QueryStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
