// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.AddTagsResponse
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AddTagsOperationDeserializer: HttpDeserializer.NonStreaming<AddTagsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AddTagsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddTagsError(context, call, payload)
        }
        val builder = AddTagsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAddTagsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ChannelARNInvalidException" -> ChannelArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ChannelNotFoundException" -> ChannelNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudTrailARNInvalidException" -> CloudTrailArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagParameterException" -> InvalidTagParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTrailNameException" -> InvalidTrailNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotOrganizationMasterAccountException" -> NotOrganizationMasterAccountExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceTypeNotSupportedException" -> ResourceTypeNotSupportedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TagsLimitExceededException" -> TagsLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
