// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.paginators

import aws.sdk.kotlin.services.cloudtrail.CloudTrailClient
import aws.sdk.kotlin.services.cloudtrail.model.Event
import aws.sdk.kotlin.services.cloudtrail.model.GetQueryResultsRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetQueryResultsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ImportFailureListItem
import aws.sdk.kotlin.services.cloudtrail.model.ImportsListItem
import aws.sdk.kotlin.services.cloudtrail.model.ListChannelsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListChannelsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListEventDataStoresRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListEventDataStoresResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListImportFailuresRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListImportFailuresResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListImportsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListImportsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListInsightsMetricDataRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListInsightsMetricDataResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListPublicKeysRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListPublicKeysResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListQueriesRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListQueriesResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListTagsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListTagsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListTrailsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListTrailsResponse
import aws.sdk.kotlin.services.cloudtrail.model.LookupEventsRequest
import aws.sdk.kotlin.services.cloudtrail.model.LookupEventsResponse
import aws.sdk.kotlin.services.cloudtrail.model.PublicKey
import aws.sdk.kotlin.services.cloudtrail.model.ResourceTag
import aws.sdk.kotlin.services.cloudtrail.model.TrailInfo
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetQueryResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetQueryResultsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetQueryResultsResponse]
 */
public fun CloudTrailClient.getQueryResultsPaginated(initialRequest: GetQueryResultsRequest): Flow<GetQueryResultsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getQueryResultsPaginated.getQueryResults(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetQueryResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetQueryResultsResponse]
 */
public fun CloudTrailClient.getQueryResultsPaginated(block: GetQueryResultsRequest.Builder.() -> Unit): Flow<GetQueryResultsResponse> =
    getQueryResultsPaginated(GetQueryResultsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun CloudTrailClient.listChannelsPaginated(initialRequest: ListChannelsRequest = ListChannelsRequest { }): Flow<ListChannelsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsPaginated.listChannels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun CloudTrailClient.listChannelsPaginated(block: ListChannelsRequest.Builder.() -> Unit): Flow<ListChannelsResponse> =
    listChannelsPaginated(ListChannelsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEventDataStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventDataStoresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventDataStoresResponse]
 */
public fun CloudTrailClient.listEventDataStoresPaginated(initialRequest: ListEventDataStoresRequest = ListEventDataStoresRequest { }): Flow<ListEventDataStoresResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventDataStoresPaginated.listEventDataStores(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEventDataStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventDataStoresResponse]
 */
public fun CloudTrailClient.listEventDataStoresPaginated(block: ListEventDataStoresRequest.Builder.() -> Unit): Flow<ListEventDataStoresResponse> =
    listEventDataStoresPaginated(ListEventDataStoresRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImportFailuresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImportFailuresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportFailuresResponse]
 */
public fun CloudTrailClient.listImportFailuresPaginated(initialRequest: ListImportFailuresRequest): Flow<ListImportFailuresResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImportFailuresPaginated.listImportFailures(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImportFailuresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportFailuresResponse]
 */
public fun CloudTrailClient.listImportFailuresPaginated(block: ListImportFailuresRequest.Builder.() -> Unit): Flow<ListImportFailuresResponse> =
    listImportFailuresPaginated(ListImportFailuresRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImportFailuresPaginated]
 * to access the nested member [ImportFailureListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImportFailureListItem]
 */
@JvmName("listImportFailuresResponseImportFailureListItem")
public fun Flow<ListImportFailuresResponse>.failures(): Flow<ImportFailureListItem> =
    transform() { response ->
        response.failures?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportsResponse]
 */
public fun CloudTrailClient.listImportsPaginated(initialRequest: ListImportsRequest = ListImportsRequest { }): Flow<ListImportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImportsPaginated.listImports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportsResponse]
 */
public fun CloudTrailClient.listImportsPaginated(block: ListImportsRequest.Builder.() -> Unit): Flow<ListImportsResponse> =
    listImportsPaginated(ListImportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImportsPaginated]
 * to access the nested member [ImportsListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImportsListItem]
 */
@JvmName("listImportsResponseImportsListItem")
public fun Flow<ListImportsResponse>.imports(): Flow<ImportsListItem> =
    transform() { response ->
        response.imports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInsightsMetricDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInsightsMetricDataRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInsightsMetricDataResponse]
 */
public fun CloudTrailClient.listInsightsMetricDataPaginated(initialRequest: ListInsightsMetricDataRequest): Flow<ListInsightsMetricDataResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInsightsMetricDataPaginated.listInsightsMetricData(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInsightsMetricDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInsightsMetricDataResponse]
 */
public fun CloudTrailClient.listInsightsMetricDataPaginated(block: ListInsightsMetricDataRequest.Builder.() -> Unit): Flow<ListInsightsMetricDataResponse> =
    listInsightsMetricDataPaginated(ListInsightsMetricDataRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPublicKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPublicKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPublicKeysResponse]
 */
public fun CloudTrailClient.listPublicKeysPaginated(initialRequest: ListPublicKeysRequest = ListPublicKeysRequest { }): Flow<ListPublicKeysResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPublicKeysPaginated.listPublicKeys(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPublicKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPublicKeysResponse]
 */
public fun CloudTrailClient.listPublicKeysPaginated(block: ListPublicKeysRequest.Builder.() -> Unit): Flow<ListPublicKeysResponse> =
    listPublicKeysPaginated(ListPublicKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPublicKeysPaginated]
 * to access the nested member [PublicKey]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PublicKey]
 */
@JvmName("listPublicKeysResponsePublicKey")
public fun Flow<ListPublicKeysResponse>.publicKeyList(): Flow<PublicKey> =
    transform() { response ->
        response.publicKeyList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListQueriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQueriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueriesResponse]
 */
public fun CloudTrailClient.listQueriesPaginated(initialRequest: ListQueriesRequest): Flow<ListQueriesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQueriesPaginated.listQueries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListQueriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueriesResponse]
 */
public fun CloudTrailClient.listQueriesPaginated(block: ListQueriesRequest.Builder.() -> Unit): Flow<ListQueriesResponse> =
    listQueriesPaginated(ListQueriesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
public fun CloudTrailClient.listTagsPaginated(initialRequest: ListTagsRequest): Flow<ListTagsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsPaginated.listTags(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
public fun CloudTrailClient.listTagsPaginated(block: ListTagsRequest.Builder.() -> Unit): Flow<ListTagsResponse> =
    listTagsPaginated(ListTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsPaginated]
 * to access the nested member [ResourceTag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceTag]
 */
@JvmName("listTagsResponseResourceTag")
public fun Flow<ListTagsResponse>.resourceTagList(): Flow<ResourceTag> =
    transform() { response ->
        response.resourceTagList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTrailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrailsResponse]
 */
public fun CloudTrailClient.listTrailsPaginated(initialRequest: ListTrailsRequest = ListTrailsRequest { }): Flow<ListTrailsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrailsPaginated.listTrails(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTrailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrailsResponse]
 */
public fun CloudTrailClient.listTrailsPaginated(block: ListTrailsRequest.Builder.() -> Unit): Flow<ListTrailsResponse> =
    listTrailsPaginated(ListTrailsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTrailsPaginated]
 * to access the nested member [TrailInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TrailInfo]
 */
@JvmName("listTrailsResponseTrailInfo")
public fun Flow<ListTrailsResponse>.trails(): Flow<TrailInfo> =
    transform() { response ->
        response.trails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [LookupEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [LookupEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LookupEventsResponse]
 */
public fun CloudTrailClient.lookupEventsPaginated(initialRequest: LookupEventsRequest = LookupEventsRequest { }): Flow<LookupEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@lookupEventsPaginated.lookupEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [LookupEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LookupEventsResponse]
 */
public fun CloudTrailClient.lookupEventsPaginated(block: LookupEventsRequest.Builder.() -> Unit): Flow<LookupEventsResponse> =
    lookupEventsPaginated(LookupEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [lookupEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("lookupEventsResponseEvent")
public fun Flow<LookupEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }
